/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.utils.math;

import net.sixik.sdmuilibrary.client.utils.math.Vector2;
import net.sixik.sdmuilibrary.client.utils.math.Vector2f;

public class Vector2d {
    public double x;
    public double y;

    public Vector2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static Vector2d create(double x, double y) {
        return new Vector2d(x, y);
    }

    public Vector2d add(Vector2d other) {
        return new Vector2d(this.x + other.x, this.y + other.y);
    }

    public Vector2d subtract(Vector2d other) {
        return new Vector2d(this.x - other.x, this.y - other.y);
    }

    public Vector2d multiply(double scalar) {
        return new Vector2d(this.x * scalar, this.y * scalar);
    }

    public Vector2d divide(double scalar) {
        return new Vector2d(this.x / scalar, this.y / scalar);
    }

    public Vector2d multiply(Vector2d scalar) {
        return new Vector2d(this.x * scalar.x, this.y * scalar.y);
    }

    public Vector2d divide(Vector2d scalar) {
        return new Vector2d(this.x / scalar.x, this.y / scalar.y);
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public Vector2d normalize() {
        double len = this.length();
        return new Vector2d(this.x / len, this.y / len);
    }

    public double dot(Vector2d other) {
        return this.x * other.x + this.y * other.y;
    }

    public Vector2d cross(Vector2d other) {
        return new Vector2d(this.y * other.x - this.x * other.y, this.x * other.y + this.y * other.x);
    }

    public Vector2 toVector2() {
        return new Vector2((int)this.x, (int)this.y);
    }

    public Vector2f toVector2f() {
        return new Vector2f((float)this.x, (float)this.y);
    }

    public Vector2d toVector2d() {
        return new Vector2d(this.x, this.y);
    }
}

