/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.utils.buffers;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.sixik.sdmuilibrary.client.utils.DrawDirection;
import net.sixik.sdmuilibrary.client.utils.math.QuadVector;
import net.sixik.sdmuilibrary.client.utils.math.TriangleVector;
import net.sixik.sdmuilibrary.client.utils.math.Vector2;
import net.sixik.sdmuilibrary.client.utils.math.Vector2f;
import net.sixik.sdmuilibrary.client.utils.misc.LineVectors;
import net.sixik.sdmuilibrary.client.utils.misc.RGB;
import net.sixik.sdmuilibrary.client.utils.misc.RGBA;
import org.joml.Matrix4f;

public class RenderBuffer2D {
    public static void addQuadToBuffer(Matrix4f m, VertexConsumer buffer, Vector2 pos, Vector2 size, RGB rgb) {
        RenderBuffer2D.addQuadToBuffer(m, buffer, pos.toVector2f(), size.toVector2f(), rgb);
    }

    public static void addQuadToBuffer(Matrix4f m, VertexConsumer buffer, Vector2f pos, Vector2f size, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        RenderBuffer2D.addQuadToBuffer(m, buffer, pos, size, r, g, b, a);
    }

    public static void addQuadToBuffer(Matrix4f m, VertexConsumer buffer, Vector2f pos, Vector2f size, int r, int g, int b, int a) {
        QuadVector quadVector = QuadVector.create(Vector2f.of(pos.x, pos.y - size.y), Vector2f.of(pos.x, pos.y), Vector2f.of(pos.x + size.x, pos.y), Vector2f.of(pos.x + size.x, pos.y - size.y));
        buffer.addVertex(m, quadVector.pos1.x, quadVector.pos1.y, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(m, quadVector.pos2.x, quadVector.pos2.y, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(m, quadVector.pos3.x, quadVector.pos3.y, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(m, quadVector.pos4.x, quadVector.pos4.y, 0.0f).setColor(r, g, b, a);
    }

    public static void addStraightToBuffer(Matrix4f m, VertexConsumer buffer, Vector2f pos, LineVectors vectors, float _long, float size, int r, int g, int b, int a) {
        QuadVector quadVector = null;
        switch (vectors) {
            case VERTICALLY: {
                quadVector = QuadVector.create(Vector2f.of(pos.x, pos.y), Vector2f.of(pos.x, pos.y + _long), Vector2f.of(pos.x + size, pos.y + _long), Vector2f.of(pos.x + size, pos.y));
                break;
            }
            case HORIZONTALLY: {
                quadVector = QuadVector.create(Vector2f.of(pos.x, pos.y), Vector2f.of(pos.x, pos.y + size), Vector2f.of(pos.x + _long, pos.y + size), Vector2f.of(pos.x + _long, pos.y));
            }
        }
        buffer.addVertex(m, quadVector.pos1.x, quadVector.pos1.y, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(m, quadVector.pos2.x, quadVector.pos2.y, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(m, quadVector.pos3.x, quadVector.pos3.y, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(m, quadVector.pos4.x, quadVector.pos4.y, 0.0f).setColor(r, g, b, a);
    }

    public static void addLineMagnetToBuffer(Matrix4f m, VertexConsumer buffer, Vector2f pos1, LineVectors magnet1, Vector2f pos2, LineVectors magnet2, float size, int r, int g, int b, int a) {
        float pos1x = 0.0f;
        float pos1y = 0.0f;
        float pos2x = 0.0f;
        float pos2y = 0.0f;
        if (magnet1.equals((Object)LineVectors.HORIZONTALLY)) {
            pos1x = pos1.x;
            pos1y = pos1.y + size;
        }
        if (magnet1.equals((Object)LineVectors.VERTICALLY)) {
            pos1x = pos1.x;
            pos1.x = size;
            pos1y = pos1.y;
        }
        if (magnet2.equals((Object)LineVectors.HORIZONTALLY)) {
            pos2x = pos2.x;
            pos2y = pos2.y + size;
        }
        if (magnet2.equals((Object)LineVectors.VERTICALLY)) {
            pos2x = pos2.x - size;
            pos2y = pos2.y;
        }
        QuadVector quadVector = QuadVector.create(Vector2f.of(pos1.x, pos1.y), Vector2f.of(pos1x, pos1y), Vector2f.of(pos2x, pos2y), Vector2f.of(pos2.x, pos2.y));
        buffer.addVertex(m, quadVector.pos1.x, quadVector.pos1.y, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(m, quadVector.pos2.x, quadVector.pos2.y, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(m, quadVector.pos3.x, quadVector.pos3.y, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(m, quadVector.pos4.x, quadVector.pos4.y, 0.0f).setColor(r, g, b, a);
    }

    public static void addTriangleToBuffer(Matrix4f m, VertexConsumer buffer, Vector2 pos, Vector2 size, DrawDirection direction, RGB rgb) {
        RenderBuffer2D.addTriangleToBuffer(m, buffer, pos.toVector2f(), size.toVector2f(), direction, rgb);
    }

    public static void addTriangleToBuffer(Matrix4f m, VertexConsumer buffer, Vector2f pos, Vector2f size, DrawDirection direction, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        RenderBuffer2D.addTriangleToBuffer(m, buffer, pos, size, direction, r, g, b, a);
    }

    public static void addTriangleToBuffer(Matrix4f m, VertexConsumer buffer, Vector2 pos, Vector2 size, DrawDirection direction, int r, int g, int b, int a) {
        RenderBuffer2D.addTriangleToBuffer(m, buffer, pos.toVector2f(), size.toVector2f(), direction, r, g, b, a);
    }

    public static void addTriangleToBuffer(Matrix4f m, VertexConsumer buffer, Vector2f pos, Vector2f size, DrawDirection direction, int r, int g, int b, int a) {
        TriangleVector triangle = null;
        switch (direction) {
            case UP: {
                triangle = TriangleVector.create(Vector2f.of(pos.x + size.x / 2.0f, pos.y - size.y), Vector2f.of(pos.x, pos.y), Vector2f.of(pos.x + size.x, pos.y));
                break;
            }
            case DOWN: {
                triangle = TriangleVector.create(Vector2f.of(pos.x, pos.y - size.y), Vector2f.of(pos.x + size.x / 2.0f, pos.y + size.y - size.y), Vector2f.of(pos.x + size.x, pos.y - size.y));
                break;
            }
            case LEFT: {
                triangle = TriangleVector.create(Vector2f.of(pos.x, pos.y - size.y / 2.0f), Vector2f.of(pos.x + size.x, pos.y), Vector2f.of(pos.x + size.x, pos.y - size.y));
                break;
            }
            case RIGHT: {
                triangle = TriangleVector.create(Vector2f.of(pos.x, pos.y - size.y), Vector2f.of(pos.x, pos.y), Vector2f.of(pos.x + size.x, pos.y - size.y / 2.0f));
            }
        }
        buffer.addVertex(m, triangle.pos1.x, triangle.pos1.y, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(m, triangle.pos2.x, triangle.pos2.y, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(m, triangle.pos3.x, triangle.pos3.y, 0.0f).setColor(r, g, b, a);
    }

    public static void addCircleToBuffer(Matrix4f m, VertexConsumer buffer, Vector2 pos, float size, int segments, RGB rgb) {
        RenderBuffer2D.addCircleToBuffer(m, buffer, pos.toVector2f(), size, segments, rgb);
    }

    public static void addCircleToBuffer(Matrix4f m, VertexConsumer buffer, Vector2f pos, float size, int segments, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        RenderBuffer2D.addCircleToBuffer(m, buffer, pos, size, segments, r, g, b, a);
    }

    public static void addCircleToBuffer(Matrix4f m, VertexConsumer buffer, Vector2f pos, float size, int segments, int r, int g, int b, int a) {
        buffer.addVertex(m, pos.x, pos.y, 0.0f).setColor(r, g, b, a);
        float angleStep = (float)(Math.PI * 2 / (double)segments);
        for (int i = segments; i >= 0; --i) {
            float angle = (float)i * angleStep;
            float x = (float)(Math.cos(angle) * (double)size) + pos.x;
            float y = (float)(Math.sin(angle) * (double)size) + pos.y;
            buffer.addVertex(m, x, y, 0.0f).setColor(r, g, b, a);
        }
    }

    public static void addArcToBuffer(Matrix4f m, VertexConsumer buffer, int cX, int cY, int radius, int startAngle, int endAngle, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        buffer.addVertex(m, (float)cX, (float)cY, 0.0f).setColor(r, g, b, a);
        for (int i = startAngle; i >= endAngle; i -= 5) {
            double angle = Math.toRadians(i);
            float x = (float)(Math.cos(angle) * (double)radius) + (float)cX;
            float y = (float)(Math.sin(angle) * (double)radius) + (float)cY;
            buffer.addVertex(m, x, y, 0.0f).setColor(r, g, b, a);
        }
    }

    public static void addRectToBufferWithUV(Matrix4f m, VertexConsumer buffer, int x, int y, int w, int h, RGB rgb, float u0, float v0, float u1, float v1) {
        if (w > 0 && h > 0) {
            int r = rgb.r;
            int g = rgb.g;
            int b = rgb.b;
            int a = 255;
            if (rgb instanceof RGBA) {
                RGBA rgba = (RGBA)rgb;
                a = rgba.a;
            }
            buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setColor(r, g, b, a).setUv(u0, v1);
            buffer.addVertex(m, (float)(x + w), (float)(y + h), 0.0f).setColor(r, g, b, a).setUv(u1, v1);
            buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(r, g, b, a).setUv(u1, v0);
            buffer.addVertex(m, (float)x, (float)y, 0.0f).setColor(r, g, b, a).setUv(u0, v0);
        }
    }
}

