/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.utils.animation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.sixik.sdmuilibrary.client.render.api.ISDMRender;
import net.sixik.sdmuilibrary.client.utils.math.Vector2;
import net.sixik.sdmuilibrary.client.utils.misc.AnimationContainer;
import net.sixik.sdmuilibrary.client.utils.renders.GLRenderHelper;
import net.sixik.sdmuilibrary.client.widgets.SDMWidget;

public class RotateAnimationContainer
implements AnimationContainer {
    public float rotateSpeed = 0.1f;
    public float rotation = 0.0f;
    private final List<ISDMRender> widgets = new ArrayList<ISDMRender>();

    public static RotateAnimationContainer create() {
        return new RotateAnimationContainer();
    }

    public RotateAnimationContainer addWidget(ISDMRender widget) {
        this.widgets.add(widget);
        return this;
    }

    public RotateAnimationContainer addWidget(ISDMRender ... widget) {
        this.widgets.addAll(new ArrayList<ISDMRender>(List.of(widget)));
        return this;
    }

    @Override
    public List<ISDMRender> getWidgets() {
        return this.widgets;
    }

    @Override
    public AnimationContainer.AnimationType getType() {
        return AnimationContainer.AnimationType.ALL_OBJECT;
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int width, int height, float tick) {
        for (ISDMRender widget : this.getWidgets()) {
            graphics.pose().pushPose();
            switch (this.getType()) {
                case ALL_OBJECT: {
                    if (widget instanceof SDMWidget) {
                        SDMWidget sdmWidget = (SDMWidget)widget;
                        GLRenderHelper.setTransform(graphics, new Vector2(sdmWidget.getX(), sdmWidget.getY()), 1.0f, this.rotation);
                    } else {
                        GLRenderHelper.setTransform(graphics, new Vector2(x, y), 1.0f, this.rotation);
                    }
                    graphics.pose().popPose();
                    break;
                }
                case CUSTOM: {
                    this.customAnimation(widget, graphics, x, y, width, height, this.rotation);
                }
            }
            graphics.pose().popPose();
        }
        this.rotation += this.rotateSpeed;
    }

    @Override
    public void customAnimation(ISDMRender widget, GuiGraphics graphics, int x, int y, int width, int height, float tick) {
    }
}

