/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.sixik.sdmuilibrary.client.utils.math.Vector2;
import net.sixik.sdmuilibrary.client.utils.math.Vector2d;
import net.sixik.sdmuilibrary.client.utils.math.Vector2f;
import net.sixik.sdmuilibrary.client.utils.misc.CenterOperators;
import net.sixik.sdmuilibrary.client.utils.misc.RGB;
import net.sixik.sdmuilibrary.client.utils.misc.RGBA;
import net.sixik.sdmuilibrary.client.utils.renders.ShapesRenderHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector4f;

public class RenderHelper {
    public static double getGuiScale() {
        return Minecraft.getInstance().getWindow().getGuiScale();
    }

    public static boolean isGamePaused() {
        return Minecraft.getInstance().isPaused();
    }

    public static Vector2 getScreenSize() {
        return new Vector2(Minecraft.getInstance().getWindow().getWidth(), Minecraft.getInstance().getWindow().getGuiScaledHeight());
    }

    public static Vector2 getScreenCenter() {
        return new Vector2(RenderHelper.getScreenSize().x / 2, RenderHelper.getScreenSize().y / 2);
    }

    public static Vector2f getMousePosition() {
        return new Vector2f((float)Minecraft.getInstance().mouseHandler.xpos(), (float)Minecraft.getInstance().mouseHandler.ypos());
    }

    public static int getTextHeight() {
        Objects.requireNonNull(Minecraft.getInstance().font);
        return 9;
    }

    public static float getTextHeight(float scale) {
        return (float)RenderHelper.getTextHeight() * scale;
    }

    public static int getTextWidth(String text) {
        return Minecraft.getInstance().font.width(text);
    }

    public static float getTextWidth(String text, float scale) {
        return (float)Minecraft.getInstance().font.width(text) * scale;
    }

    public static boolean isMouseOver(Vector2d mousePos, Vector2 pos, Vector2 size) {
        return mousePos.x >= (double)pos.x && mousePos.y >= (double)pos.y && mousePos.x < (double)(pos.x + size.x) && mousePos.y < (double)(pos.y + size.y);
    }

    public static Vector2 getMaxElementsOnSizeZone(Vector2 elementSize, Vector2 screenSize, int step, CenterOperators.Type type) {
        switch (type) {
            case CENTER_X: {
                return new Vector2(screenSize.x / (elementSize.x + step), 0);
            }
            case CENTER_Y: {
                return new Vector2(0, screenSize.y / (elementSize.y + step));
            }
        }
        return new Vector2(screenSize.x / (elementSize.x + step), screenSize.y / (elementSize.y + step));
    }

    public static void prepareTextureRendering(ResourceLocation textureLocation) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)textureLocation);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
    }

    public static void drawText(GuiGraphics poseStack, int x, int y, float size, Component text, int textColor) {
        RenderHelper.drawText(poseStack, Minecraft.getInstance().font, x, y, size, text, textColor);
    }

    public static void drawText(GuiGraphics poseStack, Font font, int x, int y, float size, Component text, int textColor) {
        poseStack.pose().pushPose();
        poseStack.pose().scale(size, size, 1.0f);
        poseStack.pose().translate((float)x, (float)y, 0.0f);
        poseStack.drawString(font, text, x, y, textColor);
        poseStack.pose().popPose();
    }

    public static void drawText(GuiGraphics graphics, Component text, int x, int y) {
        graphics.drawString(Minecraft.getInstance().font, text.getString(), x, y, RGB.create(255, 255, 255).toInt());
    }

    public static void drawText(GuiGraphics graphics, String text, int x, int y) {
        graphics.drawString(Minecraft.getInstance().font, text, x, y, RGB.create(255, 255, 255).toInt());
    }

    public static void drawText(GuiGraphics graphics, Component text, int x, int y, RGB rgb) {
        graphics.drawString(Minecraft.getInstance().font, text.getString(), x, y, rgb.toInt());
    }

    public static void drawText(GuiGraphics graphics, String text, int x, int y, RGB rgb) {
        graphics.drawString(Minecraft.getInstance().font, text, x, y, rgb.toInt());
    }

    public static void addFillToBuffer(GuiGraphics graphics, BufferBuilder buffer, int x, int y, int w, int h, RGB rgb) {
        if (w > 0 && h > 0) {
            Matrix4f m = graphics.pose().last().pose();
            int r = rgb.r;
            int g = rgb.g;
            int b = rgb.b;
            int a = 255;
            if (rgb instanceof RGBA) {
                RGBA rgba = (RGBA)rgb;
                a = rgba.a;
            }
            buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setColor(r, g, b, a);
            buffer.addVertex(m, (float)(x + w), (float)(y + h), 0.0f).setColor(r, g, b, a);
            buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(r, g, b, a);
            buffer.addVertex(m, (float)x, (float)y, 0.0f).setColor(r, g, b, a);
        }
    }

    public static void addFillTriangleToBuffer(GuiGraphics graphics, BufferBuilder buffer, int x, int y, int w, int h, RGB rgb) {
        Matrix4f m = graphics.pose().last().pose();
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        buffer.addVertex(m, (float)x, (float)y, 0.0f).setColor(r, g, b, a);
        buffer.addVertex(m, (float)(x + w / 2), (float)(y + h), 0.0f).setColor(r, g, b, a);
        buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(r, g, b, a);
    }

    public static void addFillTriangleToBufferGradient(GuiGraphics graphics, int x, int y, int w, int h, RGB startRgb, RGB endRgb) {
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        RGBA s = startRgb.toARGB();
        RGBA e = endRgb.toARGB();
        Matrix4f m = graphics.pose().last().pose();
        buffer.addVertex(m, (float)x, (float)y, 0.0f).setColor(e.r, e.g, e.b, e.a);
        buffer.addVertex(m, (float)(x + w / 2), (float)(y + h), 0.0f).setColor(s.r, s.g, s.b, s.a);
        buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(e.r, e.g, e.b, e.a);
    }

    public static void addFillToBufferGradient(GuiGraphics graphics, BufferBuilder buffer, int x, int y, int w, int h, RGB startRgb, RGB endRgb) {
        if (w > 0 && h > 0) {
            RGBA s = startRgb.toARGB();
            RGBA e = endRgb.toARGB();
            Matrix4f m = graphics.pose().last().pose();
            buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setColor(s.r, s.g, s.b, s.a);
            buffer.addVertex(m, (float)(x + w), (float)(y + h), 0.0f).setColor(s.r, s.g, s.b, s.a);
            buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(e.r, e.g, e.b, e.a);
            buffer.addVertex(m, (float)x, (float)y, 0.0f).setColor(e.r, e.g, e.b, e.a);
        }
    }

    public static void drawFillArc(GuiGraphics graphics, int cX, int cY, int radius, int start, int end, RGB rgb) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f m = graphics.pose().last().pose();
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        bufferBuilder.addVertex(m, (float)cX, (float)cY, 0.0f).setColor(r, g, b, a);
        for (int angle = start; angle <= end; ++angle) {
            double rad = Math.toRadians(angle);
            float x = (float)(Math.cos(rad) * (double)radius) + (float)cX;
            float y = (float)(Math.sin(rad) * (double)radius) + (float)cY;
            bufferBuilder.addVertex(m, x, y, 0.0f).setColor(r, g, b, a);
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    public static void drawCircle(GuiGraphics graphics, int x, int y, int radius, RGB rgb) {
        RenderHelper.drawArc(graphics, x, y, radius, 0, 360, rgb);
    }

    public static void drawFillCircle(GuiGraphics graphics, int x, int y, int radius, RGB rgb) {
        RenderHelper.drawFillArc(graphics, x, y, radius, 0, 360, rgb);
    }

    public static void drawHollowRect(GuiGraphics graphics, int x, int y, int w, int h, RGB col, boolean roundEdges) {
        if (w > 1 && h > 1 && col != null) {
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Tesselator tesselator = Tesselator.getInstance();
            BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            RenderHelper.addFillToBuffer(graphics, buffer, x, y + 1, 1, h - 2, col);
            RenderHelper.addFillToBuffer(graphics, buffer, x + w - 1, y + 1, 1, h - 2, col);
            if (roundEdges) {
                RenderHelper.addFillToBuffer(graphics, buffer, x + 1, y, w - 2, 1, col);
                RenderHelper.addFillToBuffer(graphics, buffer, x + 1, y + h - 1, w - 2, 1, col);
            } else {
                RenderHelper.addFillToBuffer(graphics, buffer, x, y, w, 1, col);
                RenderHelper.addFillToBuffer(graphics, buffer, x, y + h - 1, w, 1, col);
            }
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        } else {
            col.draw(graphics, x, y, w, h);
        }
    }

    public static void renderTexture(GuiGraphics guiGraphics, String texture, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH) {
        RenderHelper.renderTexture(guiGraphics, texture, x, y, width, height, textureX, textureY, textureW, textureH, 256);
    }

    public static void renderTexture(GuiGraphics guiGraphics, String texture, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH, int textureSize) {
        guiGraphics.blit(ResourceLocation.parse((String)texture), x, y, width, height, (float)textureX, (float)textureY, textureW, textureH, textureSize, textureSize);
    }

    public static void renderTexture(GuiGraphics guiGraphics, String texture, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH, int textureSizeX, int textureSizeY) {
        guiGraphics.blit(ResourceLocation.parse((String)texture), x, y, width, height, (float)textureX, (float)textureY, textureW, textureH, textureSizeX, textureSizeY);
    }

    public static void renderTexture(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int width, int height, int textureX, int textureY, int textureW) {
        guiGraphics.blit(texture, x, y, width, (float)height, (float)textureX, textureY, textureW, 256, 256);
    }

    public static void renderTexture(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH, int textureSize) {
        guiGraphics.blit(texture, x, y, width, (float)height, (float)textureX, textureY, textureW, textureH, textureSize);
    }

    public static void renderTexture(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int width, int height, int textureX, int textureY, int textureW, int textureH, int textureSizeX, int textureSizeY) {
        guiGraphics.blit(texture, x, y, width, height, (float)textureX, (float)textureY, textureW, textureH, textureSizeX, textureSizeY);
    }

    public static void pushScale(GuiGraphics guiGraphics, int x, int y, int scale) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale((float)scale, (float)scale, 1.0f);
        guiGraphics.pose().translate((float)(x / scale), (float)(y / scale), 0.0f);
    }

    public static void pushScale(GuiGraphics guiGraphics, int x, int y, float scale) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.pose().translate((float)((int)((float)x / scale)), (float)((int)((float)y / scale)), 0.0f);
    }

    public static void pushScale(GuiGraphics guiGraphics, int x, int y, int w, int h, int scale) {
        guiGraphics.pose().pushPose();
        float scaledWidth = w * scale;
        float scaledHeight = h * scale;
        float dx = ((float)w - scaledWidth) / 2.0f;
        float dy = ((float)h - scaledHeight) / 2.0f;
        guiGraphics.pose().translate((float)x + dx, (float)y + dy, 0.0f);
        guiGraphics.pose().scale((float)scale, (float)scale, 1.0f);
    }

    public static void pushScale(GuiGraphics guiGraphics, int x, int y, int w, int h, float scale) {
        guiGraphics.pose().pushPose();
        float scaledWidth = (float)w * scale;
        float scaledHeight = (float)h * scale;
        float dx = ((float)w - scaledWidth) / 2.0f;
        float dy = ((float)h - scaledHeight) / 2.0f;
        guiGraphics.pose().translate((float)x + dx, (float)y + dy, 0.0f);
        guiGraphics.pose().scale(scale, scale, 1.0f);
    }

    public static void popScale(GuiGraphics guiGraphics) {
        guiGraphics.pose().popPose();
    }

    public static int getScaleSize(int size, float scale) {
        return (int)((float)size * scale);
    }

    public static Vector2 getScaleSize(Vector2 size, float scale) {
        return new Vector2((int)((float)size.x * scale), (int)((float)size.y * scale));
    }

    public static void pushUpper(GuiGraphics guiGraphics) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 40.0f);
    }

    public static void pushUpper(GuiGraphics guiGraphics, float pos) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, pos);
    }

    public static void popUpper(GuiGraphics guiGraphics) {
        guiGraphics.pose().popPose();
    }

    public static void pushRotate(GuiGraphics guiGraphics, int x, int y, int w, int h, float angle) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 0.0);
        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(angle));
        guiGraphics.pose().translate((double)(-w) / 2.0, (double)(-h) / 2.0, 0.0);
    }

    public static void pushRotation(GuiGraphics guiGraphics, Vector2 pivot, float angle) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)pivot.x, (float)pivot.y, 0.0f);
        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(angle));
        guiGraphics.pose().translate((float)(-pivot.x), (float)(-pivot.y), 0.0f);
    }

    public static void pushTransform(GuiGraphics guiGraphics, Vector2 pos, Vector2 size, float scale, float rotationAngle) {
        Vector2 center = new Vector2(pos.x + size.x / 2, pos.y + size.y / 2);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)center.x, (float)center.y, 0.0f);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(rotationAngle));
        guiGraphics.pose().translate((float)(-center.x), (float)(-center.y), 0.0f);
    }

    public static void pushTransform(GuiGraphics guiGraphics, Vector2 pos, Vector2 size, Vector2 screenSize, float scale, float rotationAngle) {
        Vector2 screenCenter = new Vector2(screenSize.x, screenSize.y);
        Vector2 center = new Vector2(pos.x + size.x / 2, pos.y + size.y / 2);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)screenCenter.x, (float)screenCenter.y, 0.0f);
        guiGraphics.pose().translate((float)center.x, (float)center.y, 0.0f);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees(rotationAngle));
        guiGraphics.pose().translate((float)(-center.x), (float)(-center.y), 0.0f);
        guiGraphics.pose().translate((float)(-screenCenter.x), (float)(-screenCenter.y), 0.0f);
    }

    public static void popTransform(GuiGraphics guiGraphics) {
        guiGraphics.pose().popPose();
    }

    public static void popRotate(GuiGraphics guiGraphics) {
        guiGraphics.pose().popPose();
    }

    public static void setTransparent(GuiGraphics guiGraphics, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
    }

    public static void popTransparent() {
        RenderSystem.disableBlend();
    }

    public static void pushColor(RGB rgb) {
        float r = (float)rgb.r / 255.0f;
        float g = (float)rgb.g / 255.0f;
        float b = (float)rgb.b / 255.0f;
        float a = 1.0f;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = (float)rgba.a / 255.0f;
        }
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void popColor() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static List<String> splitTextToLines(String text, float textScale, int maxWidth) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        if (!text.contains(" ") && !text.contains("\n")) {
            return Collections.singletonList(text);
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int wordStartIndex = 0;
        boolean wordProcessing = false;
        char prevSymbol = '0';
        for (char symbol : text.toCharArray()) {
            if (symbol != ' ') {
                wordProcessing = true;
                if (prevSymbol == ' ') {
                    wordStartIndex = index;
                }
            }
            if (symbol == '\n') {
                lines.add(builder.toString());
                builder.delete(0, builder.length());
                index = 0;
                continue;
            }
            if (RenderHelper.getTextWidth(builder.toString() + symbol, textScale) <= (float)maxWidth) {
                builder.append(symbol);
            } else {
                if (symbol == '.' || symbol == ',' || symbol == '!' || symbol == '?') {
                    builder.append(symbol);
                }
                if (wordProcessing) {
                    lines.add(builder.toString().substring(0, wordStartIndex));
                    builder.delete(0, wordStartIndex);
                } else {
                    lines.add(builder.toString());
                    builder.delete(0, builder.length());
                }
                if (symbol != ' ') {
                    builder.append(symbol);
                }
                index = builder.length() - 1;
            }
            wordProcessing = false;
            prevSymbol = symbol;
            ++index;
        }
        if (builder.length() != 0) {
            lines.add(builder.toString());
        }
        return lines;
    }

    public static void enableScissor(PoseStack poseStack, double x, double y, double width, double height) {
        Matrix4f mat = poseStack.last().pose();
        Vector4f origin = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        origin.mulTranspose((Matrix4fc)mat);
        Window window = Minecraft.getInstance().getWindow();
        double scale = window.getGuiScale();
        RenderSystem.enableScissor((int)((int)((double)origin.x() * scale)), (int)(window.getHeight() - (int)(((double)origin.y() + height) * scale)), (int)((int)(width * scale)), (int)((int)(height * scale)));
    }

    public static void disableScissor() {
        RenderSystem.disableScissor();
    }

    @Deprecated
    public static void testBuffer(GuiGraphics graphics, int cX, int cY, int w, int h, RGB rgb) {
        Tesselator tesselator = Tesselator.getInstance();
        Matrix4f matrix = graphics.pose().last().pose();
        ShapesRenderHelper.drawCircle(matrix, new Vector2f(cX, cY), 50.0f, 12, rgb);
    }

    @Nullable
    public static LivingEntity getEntity(EntityType<?> type) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            Entity entity = type.create((Level)mc.level);
            return entity != null ? (LivingEntity)entity : null;
        }
        return null;
    }

    @Deprecated
    public static void drawBlock(GuiGraphics graphics, Block block, int x, int y, int scale) {
        Minecraft mc = Minecraft.getInstance();
        ItemStack blockStack = new ItemStack((ItemLike)block);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)y, 100.0f);
        graphics.pose().scale((float)scale, (float)scale, (float)scale);
        graphics.pose().popPose();
        RenderSystem.disableBlend();
    }

    public static void drawLivingEntity(GuiGraphics guiGraphics, int x, int y, double scale, double yaw, double pitch, LivingEntity livingEntity) {
        if (livingEntity.level() == null) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 50.0f);
        poseStack.scale((float)scale, (float)scale, (float)scale);
        poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        poseStack.mulPose(Axis.XP.rotationDegrees((float)Math.atan(-1.0) * 10.0f));
        livingEntity.yBodyRot = (float)(-(yaw / 40.0)) * 20.0f;
        livingEntity.setYRot((float)(-(yaw / 40.0)) * 20.0f);
        livingEntity.yHeadRot = livingEntity.getYRot();
        livingEntity.yHeadRotO = livingEntity.getYRot();
        poseStack.translate(0.0f, 0.0f, 0.0f);
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        entityRenderDispatcher.overrideCameraOrientation(new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f));
        entityRenderDispatcher.setRenderShadow(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.render((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.endBatch();
        entityRenderDispatcher.setRenderShadow(true);
        poseStack.popPose();
    }

    public static void drawItem(GuiGraphics graphics, ItemStack stack, int hash, boolean renderOverlay, @Nullable String text) {
        if (!stack.isEmpty()) {
            boolean flatLight;
            Minecraft mc = Minecraft.getInstance();
            ItemRenderer itemRenderer = mc.getItemRenderer();
            BakedModel bakedModel = itemRenderer.getModel(stack, (Level)null, (LivingEntity)mc.player, hash);
            Minecraft.getInstance().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS).setFilter(false, false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            PoseStack modelViewStack = graphics.pose();
            modelViewStack.pushPose();
            modelViewStack.mulPose(graphics.pose().last().pose());
            modelViewStack.scale(1.0f, -1.0f, 1.0f);
            modelViewStack.scale(16.0f, 16.0f, 16.0f);
            RenderSystem.applyModelViewMatrix();
            MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
            boolean bl = flatLight = !bakedModel.usesBlockLight();
            if (flatLight) {
                Lighting.setupForFlatItems();
            }
            itemRenderer.render(stack, ItemDisplayContext.GUI, false, new PoseStack(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
            bufferSource.endBatch();
            RenderSystem.enableDepthTest();
            if (flatLight) {
                Lighting.setupFor3DItems();
            }
            modelViewStack.popPose();
            RenderSystem.applyModelViewMatrix();
            if (renderOverlay) {
                float cooldown;
                Tesselator t = Tesselator.getInstance();
                Font font = mc.font;
                if (stack.getCount() != 1 || text != null) {
                    String s = text == null ? String.valueOf(stack.getCount()) : text;
                    graphics.pose().pushPose();
                    graphics.pose().translate(9.0 - (double)font.width(s), 1.0, 20.0);
                    font.drawInBatch(s, 0.0f, 0.0f, 0xFFFFFF, true, graphics.pose().last().pose(), (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    bufferSource.endBatch();
                    graphics.pose().popPose();
                }
                if (stack.isBarVisible()) {
                    RenderSystem.disableDepthTest();
                    RenderSystem.disableBlend();
                    int barWidth = stack.getBarWidth();
                    int barColor = stack.getBarColor();
                    RenderHelper.draw(graphics, t, -6, 5, 13, 2, 0, 0, 0, 255);
                    RenderHelper.draw(graphics, t, -6, 5, barWidth, 1, barColor >> 16 & 0xFF, barColor >> 8 & 0xFF, barColor & 0xFF, 255);
                    RenderSystem.enableBlend();
                    RenderSystem.enableDepthTest();
                }
                float f = cooldown = mc.player == null ? 0.0f : mc.player.getCooldowns().getCooldownPercent(stack.getItem(), 1.0f);
                if (cooldown > 0.0f) {
                    RenderSystem.disableDepthTest();
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderHelper.draw(graphics, t, -8, Mth.floor((float)(16.0f * (1.0f - cooldown))) - 8, 16, Mth.ceil((float)(16.0f * cooldown)), 255, 255, 255, 127);
                    RenderSystem.enableDepthTest();
                }
            }
        }
    }

    private static void draw(GuiGraphics graphics, Tesselator t, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        if (width > 0 && height > 0) {
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            Matrix4f m = graphics.pose().last().pose();
            BufferBuilder renderer = t.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            renderer.addVertex(m, (float)x, (float)y, 0.0f).setColor(red, green, blue, alpha);
            renderer.addVertex(m, (float)x, (float)(y + height), 0.0f).setColor(red, green, blue, alpha);
            renderer.addVertex(m, (float)(x + width), (float)(y + height), 0.0f).setColor(red, green, blue, alpha);
            renderer.addVertex(m, (float)(x + width), (float)y, 0.0f).setColor(red, green, blue, alpha);
        }
    }

    public static void drawRoundedRectUp(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        RenderHelper.fillRect(guiGraphics, x, y + radius, width, height - radius, RGBA.create(r, g, b, a));
        RenderHelper.fillRect(guiGraphics, x + radius, y, width - radius * 2, radius, RGBA.create(r, g, b, a));
        RenderHelper.drawArc(guiGraphics, x + radius, y + radius, radius, 270, 180, RGBA.create(r, g, b, a));
        RenderHelper.drawArc(guiGraphics, x + width - radius, y + radius, radius, 0, -90, RGBA.create(r, g, b, a));
    }

    public static void drawRoundedRectDown(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        RenderHelper.fillRect(guiGraphics, x, y, width, height - radius, RGBA.create(r, g, b, a));
        RenderHelper.fillRect(guiGraphics, x + radius, y + height - radius, width - radius * 2, radius, RGBA.create(r, g, b, a));
        RenderHelper.drawArc(guiGraphics, x + radius, y + height - radius, radius, -180, -270, RGBA.create(r, g, b, a));
        RenderHelper.drawArc(guiGraphics, x + width - radius, y + height - radius, radius, 90, 0, RGBA.create(r, g, b, a));
    }

    public static void drawRoundedRect(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        RenderHelper.fillRect(guiGraphics, x + radius, y, width - radius * 2, height, rgb);
        RenderHelper.fillRect(guiGraphics, x, y + radius, radius, height - radius * 2, rgb);
        RenderHelper.fillRect(guiGraphics, x + width - radius, y + radius, radius, height - radius * 2, rgb);
        RenderHelper.drawArc(guiGraphics, x + radius, y + radius, radius, 270, 180, rgb);
        RenderHelper.drawArc(guiGraphics, x + width - radius, y + radius, radius, 0, -90, rgb);
        RenderHelper.drawArc(guiGraphics, x + radius, y + height - radius, radius, -180, -270, rgb);
        RenderHelper.drawArc(guiGraphics, x + width - radius, y + height - radius, radius, 90, 0, rgb);
    }

    public static void fillRect(GuiGraphics guiGraphics, int x, int y, int width, int height, RGB rgb) {
        guiGraphics.fill(x, y, x + width, y + height, RenderHelper.rgbaToInt(rgb.r, rgb.g, rgb.b, rgb instanceof RGBA ? ((RGBA)rgb).a : 255));
    }

    public static void drawArc(GuiGraphics graphics, int cX, int cY, int radius, int startAngle, int endAngle, RGB rgb) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f m = graphics.pose().last().pose();
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        RenderSystem.enableBlend();
        bufferBuilder.addVertex(m, (float)cX, (float)cY, 0.0f).setColor(r, g, b, a);
        for (int i = startAngle; i >= endAngle; i -= 5) {
            double angle = Math.toRadians(i);
            float x = (float)(Math.cos(angle) * (double)radius) + (float)cX;
            float y = (float)(Math.sin(angle) * (double)radius) + (float)cY;
            bufferBuilder.addVertex(m, x, y, 0.0f).setColor(r, g, b, a);
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static int rgbaToInt(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void pushScissor(GuiGraphics guiGraphics, Vector2 pos, Vector2 size) {
        guiGraphics.enableScissor(pos.x, pos.y, pos.x + size.x, pos.y + size.y);
        guiGraphics.pose().pushPose();
    }

    public static void popScissor(GuiGraphics guiGraphics) {
        guiGraphics.pose().popPose();
        guiGraphics.disableScissor();
    }
}

