/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.sixik.sdmuilibrary.client.utils.RenderHelper;
import net.sixik.sdmuilibrary.client.utils.misc.RGB;

public class FakeWidgetRender {
    public static void singleLineText(GuiGraphics graphics, Component component, int x, int y) {
        graphics.drawString(Minecraft.getInstance().font, component.getString(), x, y, RGB.create(255, 255, 255).toInt());
    }

    public static void singleLineSizableText(GuiGraphics graphics, Component component, float size, int x, int y) {
        RenderHelper.pushScale(graphics, x, y, size);
        graphics.drawString(Minecraft.getInstance().font, component.getString(), x, y, RGB.create(255, 255, 255).toInt());
        RenderHelper.popScale(graphics);
    }

    public static void multiLineText(GuiGraphics graphics, Component component, int x, int y, int width) {
        List<String> lines = FakeWidgetRender.calculate(component, width);
        int posY = y;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            graphics.drawString(Minecraft.getInstance().font, line, x, posY, RGB.create(255, 255, 255).toInt());
            Objects.requireNonNull(Minecraft.getInstance().font);
            posY += 9 * i + 2;
        }
    }

    public static void multiLineSizableText(GuiGraphics graphics, Component component, float size, int x, int y, int width) {
        RenderHelper.pushScale(graphics, x, y, size);
        List<String> lines = FakeWidgetRender.calculate(component, width);
        int posY = y;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            graphics.drawString(Minecraft.getInstance().font, line, x, posY, RGB.create(255, 255, 255).toInt());
            Objects.requireNonNull(Minecraft.getInstance().font);
            posY += 9 * i + 2;
        }
        RenderHelper.popScale(graphics);
    }

    private static List<String> calculate(Component text, int width) {
        ArrayList<String> lines = new ArrayList<String>();
        int currentLine = 0;
        for (String line : text.getString().split("\n")) {
            if (Minecraft.getInstance().font.width(line) > width) {
                String[] words = line.split(" ");
                StringBuilder currentWord = new StringBuilder();
                for (String word : words) {
                    if (Minecraft.getInstance().font.width(currentWord.toString() + " " + word) > width) {
                        lines.add(currentWord.toString());
                        currentWord.setLength(0);
                        ++currentLine;
                    }
                    currentWord.append(word).append(" ");
                }
                if (currentWord.isEmpty()) continue;
                lines.add(currentWord.toString());
                continue;
            }
            lines.add(line);
        }
        return lines;
    }
}

