/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.screen.examples;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.sixik.sdmuilibrary.client.screen.BaseScreen;
import net.sixik.sdmuilibrary.client.utils.RenderHelper;
import net.sixik.sdmuilibrary.client.utils.math.Vector2;
import net.sixik.sdmuilibrary.client.utils.misc.CenterOperators;
import net.sixik.sdmuilibrary.client.utils.misc.Colors;
import net.sixik.sdmuilibrary.client.utils.renders.TextRenderHelper;
import net.sixik.sdmuilibrary.client.widgets.RenderWidget;
import net.sixik.sdmuilibrary.client.widgets.buttons.BasicButtonWidget;
import net.sixik.sdmuilibrary.client.widgets.buttons.SimpleButtonWidget;

public class GameUIScreen
extends BaseScreen {
    public static List<String> list = List.of("Fobos", "\u042f \u0431\u043e\u043b\u044c\u0448\u043e\u0439 \u043c\u0430\u043b\u044c\u0447\u0438\u043a", "\u0422\u0435\u0441\u0442\u043e\u0432\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
    public int selectedTab = 0;
    public int selectedButtonOnPage = -1;
    public int countButtons = 6;
    public Vector2 buttonSize;
    public RenderWidget page1Container;

    @Override
    protected void addWidgets() {
        for (int i = 0; i < this.countButtons; ++i) {
            final int d1 = i;
            Vector2 position = new Vector2(this.position.x + 1 + this.size.x / this.countButtons * i, this.position.y - this.buttonSize.y);
            SimpleButtonWidget simpleButtonWidget = (SimpleButtonWidget)this.addRenderableWidget((GuiEventListener)new SimpleButtonWidget((Component)Component.literal((String)("Tab" + (i + 1))), position, this.buttonSize){

                @Override
                public void onClick(double mouseX, double mouseY) {
                    if (GameUIScreen.this.selectedTab != d1) {
                        GameUIScreen.this.selectedTab = d1;
                        GameUIScreen.this.selectedButtonOnPage = -1;
                    }
                }

                @Override
                public void draw(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, float tick) {
                    if (GameUIScreen.this.selectedTab == d1) {
                        super.draw(graphics, x, y - 10, width, height + 10, mouseX, mouseY, tick);
                    } else {
                        super.draw(graphics, x, y, width, height, mouseX, mouseY, tick);
                    }
                }

                @Override
                public CenterOperators.Type getCenteredType() {
                    return CenterOperators.Type.CENTER_XY;
                }
            });
        }
        this.createPage1();
        this.createPage2();
    }

    @Override
    protected void rebuildProperty() {
        super.rebuildProperty();
        Vector2 screenSize = this.size;
        this.size = this.size.multiply(4).divide(6);
        this.position = screenSize.divide(2).subtract(new Vector2(this.size.x / 2, this.size.y / 2));
        this.buttonSize = new Vector2(this.size.x / this.countButtons, 20);
    }

    @Override
    public void draw(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.page1Container.visible = this.selectedTab == 0;
        this.drawBackground(graphics, mouseX, mouseY, partialTicks);
    }

    public void drawBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Colors.POLAR_NIGHT_0.draw(graphics, this.position.x, this.position.y, this.size.x, this.size.y);
        RenderHelper.drawHollowRect(graphics, this.position.x - 1, this.position.y - 1, this.size.x + 2, this.size.y + 2, Colors.POLAR_NIGHT_1, false);
        this.drawPage(graphics, mouseX, mouseY, partialTicks);
    }

    public void drawPage(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Vector2 pos = this.position.add(new Vector2(0, 10));
        if (this.selectedTab == 0) {
            int _sizeXMax = this.size.x - this.size.x / 6 * 2;
            Colors.POLAR_NIGHT_4.draw(graphics, pos.x + this.size.x - _sizeXMax, pos.y - 10, _sizeXMax, this.size.y);
            if (this.selectedButtonOnPage != -1) {
                pos = new Vector2(pos.x + this.size.x - _sizeXMax, pos.y).add(new Vector2(5, 5));
                String text = list.get(this.selectedButtonOnPage);
                TextRenderHelper.drawText(graphics, text, pos.x, pos.y);
            }
        }
    }

    public void createPage1() {
        this.page1Container = new RenderWidget(this.position, new Vector2(this.size.x - this.size.x / 6 * 2, this.size.y));
        int pageButtons = list.size();
        Vector2 pageButtonSize = new Vector2(16, 16);
        Vector2 pos = new Vector2(this.position.x + 10, this.position.y + 10);
        Vector2 _size = new Vector2(pageButtonSize.x, pageButtonSize.y);
        int _sizeXMax = this.page1Container.getWidth();
        for (int i = 0; i < pageButtons; ++i) {
            final int d1 = i;
            if (i != 0) {
                if (_size.add((Vector2)new Vector2((int)32, (int)0)).add((Vector2)new Vector2((int)2, (int)0)).x >= _sizeXMax) {
                    _size = pageButtonSize.add(new Vector2(2, 2));
                    pos = new Vector2(this.position.x + 10, pos.y + 2 + pageButtonSize.y);
                } else {
                    _size = _size.add(new Vector2(34, 0));
                    pos = pos.add(new Vector2(pageButtonSize.x, 0)).add(new Vector2(2, 0));
                }
            }
            this.page1Container.addRenderableWidget(new BasicButtonWidget(pos, pageButtonSize){

                @Override
                public void onClick(double mouseX, double mouseY) {
                    if (GameUIScreen.this.selectedButtonOnPage != d1) {
                        GameUIScreen.this.selectedButtonOnPage = d1;
                    }
                }

                @Override
                public void drawBackground(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, float tick) {
                    if (GameUIScreen.this.selectedButtonOnPage != -1 && GameUIScreen.this.selectedButtonOnPage == d1) {
                        Colors.UI_GOLD_1.draw(graphics, x, y, width, height);
                    } else {
                        Colors.UI_GOLD_0.draw(graphics, x, y, width, height);
                    }
                }
            });
        }
        this.addRenderableWidget((GuiEventListener)this.page1Container);
    }

    public void createPage2() {
    }
}

