/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.screen;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.sixik.sdmuilibrary.client.utils.math.Vector2;
import net.sixik.sdmuilibrary.client.utils.renders.GLRenderHelper;
import net.sixik.sdmuilibrary.client.widgets.RenderWidget;
import net.sixik.sdmuilibrary.client.widgets.SDMWidget;
import net.sixik.sdmuilibrary.mixin.ScreenAccessor;
import org.jetbrains.annotations.NotNull;

public class BaseScreen
extends Screen {
    public Vector2 size = new Vector2(0, 0);
    public Vector2 position = new Vector2(0, 0);

    public BaseScreen() {
        super((Component)Component.empty());
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.draw(graphics, mouseX, mouseY, partialTicks);
        for (Renderable renderable : ((ScreenAccessor)((Object)this)).getRenderables()) {
            if (renderable instanceof RenderWidget) {
                RenderWidget renderWiget = (RenderWidget)renderable;
                if (renderWiget.scissor) {
                    GLRenderHelper.enableScissor(graphics, this.position, this.size);
                    renderable.render(graphics, mouseX, mouseY, partialTicks);
                    GLRenderHelper.disableScissor(graphics);
                    continue;
                }
                renderable.render(graphics, mouseX, mouseY, partialTicks);
                continue;
            }
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void addWidgets() {
    }

    protected void init() {
        super.init();
        this.rebuildProperty();
        this.addWidgets();
    }

    protected void rebuildWidgets() {
        super.rebuildWidgets();
        this.rebuildProperty();
    }

    protected void rebuildProperty() {
        this.size = new Vector2(Minecraft.getInstance().getWindow().getGuiScaledWidth(), Minecraft.getInstance().getWindow().getGuiScaledHeight());
        this.position = new Vector2(0, 0);
    }

    public void tick() {
        for (Renderable renderable : ((ScreenAccessor)((Object)this)).getRenderables()) {
            if (!(renderable instanceof SDMWidget)) continue;
            SDMWidget widget = (SDMWidget)renderable;
            widget.tick();
        }
    }

    public void draw(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }
}

