/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.integration.imgui.utils;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class ImGuiGLRenderHelper {
    public static void renderItemStack(ItemStack itemStack, PoseStack stack, float x, float y, float width, float height, float scale, float rotation) {
        boolean flat;
        float xOffset = x + width / 2.0f;
        float yOffset = y + height / 2.0f;
        stack.translate(xOffset, yOffset, 0.0f);
        float newScale = Math.min(width, height) * 0.95f * scale;
        stack.scale(newScale, -newScale, newScale);
        stack.mulPose(new Quaternionf().rotateZ(rotation * ((float)Math.PI / 180)));
        MultiBufferSource.BufferSource src = Minecraft.getInstance().renderBuffers().bufferSource();
        BakedModel model = Minecraft.getInstance().getItemRenderer().getModel(itemStack, (Level)Minecraft.getInstance().level, null, 0);
        boolean bl = flat = !model.usesBlockLight();
        if (flat) {
            Lighting.setupForFlatItems();
        }
        Minecraft.getInstance().getItemRenderer().render(itemStack, ItemDisplayContext.GUI, false, stack, (MultiBufferSource)src, 0xF000F0, OverlayTexture.NO_OVERLAY, model);
        src.endBatch();
        if (flat) {
            Lighting.setupFor3DItems();
        }
    }

    public static void renderItemDecorations(ItemStack stack, PoseStack poseStack, int x, int y, float width, float height) {
        float f;
        if (stack.isBarVisible()) {
            float i = (float)stack.getBarWidth() / 16.0f;
            int j = stack.getBarColor();
            float k = (float)x + width * 0.125f;
            float l = (float)y + height * 0.8125f;
            ImGuiGLRenderHelper.fill(poseStack, RenderType.guiOverlay(), (int)k, (int)l, (int)(k + width * 0.8125f), (int)(l + height * 0.125f), 0, -16777216);
            ImGuiGLRenderHelper.fill(poseStack, RenderType.guiOverlay(), (int)k, (int)l, (int)(k + i * width), (int)(l + height * 0.0625f), 10, FastColor.ABGR32.opaque((int)j));
        }
        if ((f = Minecraft.getInstance().player.getCooldowns().getCooldownPercent(stack.getItem(), Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true))) > 0.0f) {
            float k = (float)y + width * ((float)Mth.floor((float)(16.0f * (1.0f - f))) / 16.0f);
            float l = k + height * (float)Mth.ceil((float)(16.0f * f)) / 16.0f;
            ImGuiGLRenderHelper.fill(poseStack, RenderType.guiOverlay(), x, (int)k, (int)((float)x + width), (int)l, 0, Integer.MAX_VALUE);
        }
    }

    public static void fill(PoseStack stack, RenderType renderType, int minX, int minY, int maxX, int maxY, int z, int color) {
        int i;
        Matrix4f matrix4f = stack.last().pose();
        if (minX < maxX) {
            i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            i = minY;
            minY = maxY;
            maxY = i;
        }
        MultiBufferSource.BufferSource src = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vertexConsumer = src.getBuffer(renderType);
        vertexConsumer.addVertex(matrix4f, (float)minX, (float)minY, (float)z).setColor(color);
        vertexConsumer.addVertex(matrix4f, (float)minX, (float)maxY, (float)z).setColor(color);
        vertexConsumer.addVertex(matrix4f, (float)maxX, (float)maxY, (float)z).setColor(color);
        vertexConsumer.addVertex(matrix4f, (float)maxX, (float)minY, (float)z).setColor(color);
        RenderSystem.disableDepthTest();
        src.endBatch();
        RenderSystem.enableDepthTest();
    }
}

