/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.integration.imgui.screen.nodes;

import java.util.HashMap;
import net.sixik.sdmuilibrary.client.integration.imgui.screen.nodes.ImNode;
import net.sixik.sdmuilibrary.client.integration.imgui.screen.nodes.ImNodePin;
import org.jetbrains.annotations.Nullable;

public class NodesData<T extends ImNode> {
    protected long nextNodeID = 1L;
    protected long nextPinID = 50000L;
    public final HashMap<Long, T> nodes = new HashMap();

    @Nullable
    public T findByInputPin(long pinID) {
        for (ImNode node : this.nodes.values()) {
            for (ImNodePin pin : node.nodePins) {
                if (!pin.type.isInput() || pin.pinID != pinID) continue;
                return (T)node;
            }
        }
        return null;
    }

    @Nullable
    public T findByOutputPin(long pinID) {
        for (ImNode node : this.nodes.values()) {
            for (ImNodePin pin : node.nodePins) {
                if (!pin.type.isOutput() || pin.pinID != pinID) continue;
                return (T)node;
            }
        }
        return null;
    }

    @Nullable
    public T findByPin(long pinID) {
        T node = this.findByInputPin(pinID);
        if (node == null) {
            node = this.findByOutputPin(pinID);
        }
        return node;
    }

    @Nullable
    public T getNode(long nodeId) {
        return (T)((ImNode)this.nodes.getOrDefault(nodeId, null));
    }

    public T createNode(T type) {
        ((ImNode)type).nodeID = this.nextNodeID++;
        ((ImNode)type).nodePins.forEach(pin -> {
            pin.pinID = this.nextPinID++;
        });
        this.nodes.put(((ImNode)type).nodeID, type);
        return type;
    }
}

