/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.integration.imgui.screen;

import imgui.ImGui;
import imgui.ImVec2;
import imgui.type.ImBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.sixik.sdmuilibrary.client.integration.imgui.IRenderable;
import net.sixik.sdmuilibrary.client.integration.imgui.ImGuiScreenWrapper;

public abstract class AbstractImGuiScreen
implements IRenderable {
    protected final String screenName;
    protected boolean showScreen;
    protected ImVec2 screenSize = new ImVec2(ImGui.getIO().getDisplaySizeX(), ImGui.getIO().getDisplaySizeY());
    protected ImVec2 position = new ImVec2(0.0f, 0.0f);
    protected boolean setPosition = false;
    protected boolean setSize = false;
    protected int imGuiCond = 1;
    protected int imGuiFlags;

    public AbstractImGuiScreen(String screenName) {
        this(screenName, true);
    }

    public AbstractImGuiScreen(String screenName, boolean showScreen) {
        this.screenName = screenName;
        this.showScreen = showScreen;
    }

    public AbstractImGuiScreen setFullScreen() {
        this.screenSize.set((float)Minecraft.getInstance().getWindow().getWidth(), (float)Minecraft.getInstance().getWindow().getHeight());
        return this;
    }

    public AbstractImGuiScreen setScreenSize(int w, int h) {
        this.screenSize.set((float)w, (float)h);
        return this;
    }

    public AbstractImGuiScreen addFlags(int imGuiFlags) {
        this.imGuiFlags |= imGuiFlags;
        return this;
    }

    public AbstractImGuiScreen setPos(int x, int y) {
        this.position = new ImVec2((float)x, (float)y);
        return this;
    }

    public ImVec2 getScreenSize() {
        return this.screenSize;
    }

    public ImVec2 getPosition() {
        return this.position;
    }

    public String getScreenName() {
        return this.screenName;
    }

    @Override
    public final void renderImGui(int imGuiFlags, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.initImGuiScreen(imGuiFlags | this.imGuiFlags, guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void initImGuiScreen(int imGuiFlags, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.showScreen) {
            ImBoolean close = new ImBoolean();
            if (!this.setPosition) {
                ImGui.setNextWindowPos((float)this.position.x, (float)this.position.y, (int)this.imGuiCond);
                this.setPosition = true;
            }
            if (!this.setSize) {
                ImGui.setNextWindowSize((float)this.screenSize.x, (float)this.screenSize.y, (int)this.imGuiCond);
                this.setSize = true;
            }
            if (ImGui.begin((String)this.screenName, (ImBoolean)close, (int)imGuiFlags)) {
                this.render(imGuiFlags, guiGraphics, mouseX, mouseY, partialTick);
            }
            ImGui.end();
            this.onScreenClose(close);
        }
    }

    protected void onScreenClose(ImBoolean value) {
        Screen screen;
        if (value.get() && (screen = Minecraft.getInstance().screen) instanceof ImGuiScreenWrapper) {
            ImGuiScreenWrapper screenWrapper = (ImGuiScreenWrapper)screen;
            screenWrapper.onClose();
        }
    }

    public abstract void render(int var1, GuiGraphics var2, int var3, int var4, float var5);
}

