/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.integration.imgui.modules.editor;

import imgui.ImGui;
import imgui.type.ImBoolean;
import java.util.function.Consumer;
import net.minecraft.core.Vec3i;

public class BTSEnginePropertiesEditors {
    public static void objectTransformEditor(String name, ObjectTransform<Vec3i> transform, Consumer<ObjectTransform<Vec3i>> consumer, ImBoolean open) {
        boolean isChanged = false;
        ImGui.pushID((String)name);
        ObjectTransform<Object> newPos = new ObjectTransform(transform.position);
        if (ImGui.collapsingHeader((String)"Transform")) {
            Object pos = transform.position;
            int[] array = new int[]{pos.getX(), pos.getY(), pos.getZ()};
            if (ImGui.inputInt3((String)"Position (X,Y,Z)", (int[])array)) {
                isChanged = true;
                newPos = new ObjectTransform<Vec3i>(new Vec3i(array[0], array[1], array[2]));
            }
            if (transform instanceof ObjectTransformWithRotation) {
                ObjectTransformWithRotation rotation = (ObjectTransformWithRotation)transform;
                float[] arrayRot = new float[]{rotation.xRot, rotation.yRot};
                if (ImGui.inputFloat2((String)"Rotation (X,Y)", (float[])arrayRot)) {
                    isChanged = true;
                    rotation.xRot = arrayRot[0];
                    rotation.yRot = arrayRot[1];
                }
            }
        }
        if (isChanged) {
            consumer.accept(newPos);
        }
        ImGui.popID();
    }

    public static class ObjectTransform<T extends Vec3i> {
        public T position;

        public ObjectTransform(T position) {
            this.position = position;
        }

        public int hashCode() {
            return this.position.hashCode();
        }
    }

    public static class ObjectTransformWithRotation<T extends Vec3i>
    extends ObjectTransform<T> {
        public float yRot;
        public float xRot;

        public ObjectTransformWithRotation(T position, float yRot, float xRot) {
            super(position);
            this.yRot = yRot;
            this.xRot = xRot;
        }

        @Override
        public int hashCode() {
            return (int)((float)super.hashCode() + this.yRot + this.xRot);
        }
    }
}

