/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.integration.imgui.modules.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import imgui.ImGui;
import imgui.ImVec2;
import imgui.type.ImBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Vec3i;
import net.sixik.sdmuilibrary.client.integration.imgui.IRenderable;
import net.sixik.sdmuilibrary.client.integration.imgui.extern.BTSImGui;
import net.sixik.sdmuilibrary.client.integration.imgui.modules.editor.BTSEnginePropertiesEditors;
import org.joml.Matrix4f;

public class BTSEngineEditor
implements IRenderable {
    protected float mainX;
    protected float mainY;
    protected float mainWidth;
    protected float mainHeight;
    protected static boolean additionalMenu = false;
    protected static boolean additionalMenu2 = false;
    protected static boolean configEditorOpen = false;
    protected static Matrix4f modelViewMatrix = RenderSystem.getModelViewMatrix();
    protected static Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();

    private ImVec2 getScreenSize() {
        return new ImVec2((float)Minecraft.getInstance().getWindow().getWidth(), (float)Minecraft.getInstance().getWindow().getHeight());
    }

    @Override
    public void renderImGui(int imGuiFlags, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ImBoolean imBoolean;
        ImGui.setNextWindowPos((float)0.0f, (float)0.0f, (int)2);
        ImGui.setNextWindowSize((ImVec2)this.getScreenSize(), (int)1);
        ImGui.begin((String)"Main Panel", (int)2106375);
        this.updateMainScreenFields();
        this.renderMainToolBar();
        int dockspaceID = ImGui.getID((String)"MainDockSpace");
        ImGui.dockSpace((int)dockspaceID);
        ImGui.end();
        if (additionalMenu) {
            ImGui.setNextWindowSize((float)200.0f, (float)150.0f, (int)2);
            imBoolean = new ImBoolean(additionalMenu);
            if (ImGui.begin((String)"Inspector", (ImBoolean)imBoolean)) {
                additionalMenu = imBoolean.get();
            }
            this.checkIsWindowOutside();
            BTSEnginePropertiesEditors.objectTransformEditor("TestEdit", new BTSEnginePropertiesEditors.ObjectTransformWithRotation<Vec3i>(new Vec3i(0, 0, 0), 20.0f, 20.0f), s -> {}, imBoolean);
            if (ImGui.collapsingHeader((String)"Model Matrix")) {
                BTSImGui.beginEditElementMatrix4f("Model", modelViewMatrix, s -> {});
            }
            if (ImGui.collapsingHeader((String)"Projection Matrix")) {
                BTSImGui.beginEditElementMatrix4f("Projection", projectionMatrix, s -> {});
            }
            ImGui.end();
        }
        if (additionalMenu2) {
            ImGui.setNextWindowSize((float)200.0f, (float)150.0f, (int)2);
            imBoolean = new ImBoolean(additionalMenu2);
            if (ImGui.begin((String)"Child Panel 2", (ImBoolean)imBoolean)) {
                additionalMenu2 = imBoolean.get();
            }
            this.checkIsWindowOutside();
            ImGui.text((String)"Another movable panel!");
            ImGui.end();
        }
    }

    protected void renderConfigEditor() {
        if (!configEditorOpen) {
            return;
        }
        ImGui.setNextWindowSize((float)200.0f, (float)150.0f, (int)2);
        ImBoolean imBoolean = new ImBoolean(configEditorOpen);
        if (ImGui.begin((String)"Config Editor", (ImBoolean)imBoolean)) {
            configEditorOpen = imBoolean.get();
        }
        this.checkIsWindowOutside();
        ImGui.end();
    }

    protected void renderMainToolBar() {
        ImGui.pushID((String)"MainToolBar");
        if (ImGui.beginMenuBar()) {
            if (ImGui.beginMenu((String)"File", (boolean)false)) {
                ImGui.endMenu();
            }
            if (ImGui.beginMenu((String)"View")) {
                ImGui.separatorText((String)"Windows");
                if (ImGui.menuItem((String)("AdditionalMenu " + (additionalMenu ? "\u2714 " : "")), (boolean)additionalMenu)) {
                    additionalMenu = !additionalMenu;
                }
                if (ImGui.menuItem((String)("AdditionalMenu2" + (additionalMenu2 ? "\u2714 " : "")), (boolean)additionalMenu2)) {
                    additionalMenu2 = !additionalMenu2;
                }
                if (ImGui.menuItem((String)("Config Editor" + (configEditorOpen ? "\u2714 " : "")), (boolean)configEditorOpen)) {
                    configEditorOpen = !configEditorOpen;
                }
                ImGui.endMenu();
            }
            ImGui.endMenuBar();
        }
        ImGui.popID();
    }

    protected void updateMainScreenFields() {
        this.mainX = ImGui.getWindowPosX();
        this.mainY = ImGui.getWindowPosY();
        this.mainWidth = ImGui.getWindowWidth();
        this.mainHeight = ImGui.getWindowHeight();
    }

    protected void checkIsWindowOutside() {
        float childX = ImGui.getWindowPosX();
        float childY = ImGui.getWindowPosY();
        float childWidth = ImGui.getWindowWidth();
        float childHeight = ImGui.getWindowHeight();
        childX = Math.max(this.mainX, Math.min(childX, this.mainX + this.mainWidth - childWidth));
        childY = Math.max(this.mainY, Math.min(childY, this.mainY + this.mainHeight - childHeight));
        ImGui.setWindowPos((float)childX, (float)childY);
        ImGui.setWindowSize((float)Math.clamp(childWidth, 1.0f, this.mainWidth), (float)Math.clamp(childHeight, 1.0f, this.mainHeight));
    }
}

