/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.integration.imgui.modules;

import imgui.ImGui;
import imgui.ImGuiInputTextCallbackData;
import imgui.callback.ImGuiInputTextCallback;
import imgui.type.ImString;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.sixik.sdmuilibrary.client.integration.imgui.IRenderable;

public class BTScriptalTerminal
implements IRenderable {
    private final ImString inputBuffer = new ImString();
    private final List<String> outputLines = new ArrayList<String>();
    private static final List<String> commandHistory = new ArrayList<String>();
    private int historyIndex = -1;
    public Function<String, String> commandExec;

    public BTScriptalTerminal(Function<String, String> commandExec) {
        this.commandExec = commandExec;
    }

    @Override
    public void renderImGui(int imGuiFlags, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        String input;
        ImGui.beginChild((String)"Output", (float)0.0f, (float)(-ImGui.getFrameHeightWithSpacing()), (boolean)true);
        for (String line : this.outputLines) {
            ImGui.textWrapped((String)line);
        }
        if (ImGui.getScrollY() >= ImGui.getScrollMaxY()) {
            ImGui.setScrollHereY((float)1.0f);
        }
        ImGui.endChild();
        ImGui.pushItemWidth((float)-1.0f);
        if (ImGui.inputText((String)"##Input", (ImString)this.inputBuffer, (int)262432, (ImGuiInputTextCallback)new ImGuiInputTextCallback(){

            public void accept(ImGuiInputTextCallbackData imGuiInputTextCallbackData) {
                BTScriptalTerminal.this.inputTextCallback(imGuiInputTextCallbackData);
            }
        }) && !(input = this.inputBuffer.get().trim()).isEmpty()) {
            this.processInput(input);
            this.inputBuffer.set((Object)Character.valueOf('\u0000'));
        }
        ImGui.popItemWidth();
        this.handleArrowKeys();
    }

    private void processInput(String input) {
        this.outputLines.add("> " + input);
        commandHistory.add(input);
        this.historyIndex = commandHistory.size();
        String output = this.executeCommand(input);
        if (output != null && !output.isEmpty()) {
            this.outputLines.add(output);
        }
        if (this.outputLines.size() > 100) {
            this.outputLines.removeFirst();
        }
    }

    private String executeCommand(String command) {
        if (command.equalsIgnoreCase("clear")) {
            this.outputLines.clear();
            return null;
        }
        return this.commandExec.apply(command);
    }

    private int inputTextCallback(ImGuiInputTextCallbackData data) {
        if (ImGui.isKeyPressed((int)ImGui.getKeyIndex((int)515))) {
            if (this.historyIndex > 0) {
                --this.historyIndex;
                String previousCommand = commandHistory.get(this.historyIndex);
                this.inputBuffer.set(previousCommand);
                data.setCursorPos(previousCommand.length());
                data.setSelectionStart(previousCommand.length());
                data.setSelectionEnd(previousCommand.length());
                data.setBufDirty(true);
            }
        } else if (ImGui.isKeyPressed((int)ImGui.getKeyIndex((int)516))) {
            if (this.historyIndex < commandHistory.size() - 1) {
                ++this.historyIndex;
                String nextCommand = commandHistory.get(this.historyIndex);
                this.inputBuffer.set(nextCommand);
                data.setCursorPos(nextCommand.length());
                data.setSelectionStart(nextCommand.length());
                data.setSelectionEnd(nextCommand.length());
                data.setBufDirty(true);
            } else if (this.historyIndex == commandHistory.size() - 1) {
                ++this.historyIndex;
                this.inputBuffer.set("");
                data.setCursorPos(0);
                data.setSelectionStart(0);
                data.setSelectionEnd(0);
                data.setBufDirty(true);
            }
        }
        return 0;
    }

    private void handleArrowKeys() {
        if (ImGui.isKeyPressed((int)ImGui.getKeyIndex((int)515)) && this.historyIndex > 0) {
            --this.historyIndex;
            this.inputBuffer.set(commandHistory.get(this.historyIndex));
        }
        if (ImGui.isKeyPressed((int)ImGui.getKeyIndex((int)516))) {
            if (this.historyIndex < commandHistory.size() - 1) {
                ++this.historyIndex;
                this.inputBuffer.set(commandHistory.get(this.historyIndex));
            } else if (this.historyIndex == commandHistory.size() - 1) {
                ++this.historyIndex;
                this.inputBuffer.set("");
            }
        }
    }
}

