/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.integration.imgui.init;

import com.mojang.blaze3d.systems.RenderSystem;
import imgui.ImFont;
import imgui.ImFontConfig;
import imgui.ImFontGlyphRangesBuilder;
import imgui.ImGui;
import imgui.ImGuiIO;
import imgui.ImGuiStyle;
import imgui.extension.imnodes.ImNodes;
import imgui.gl3.ImGuiImplGl3;
import imgui.glfw.ImGuiImplGlfw;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.sixik.sdmuilibrary.SDMUILibrary;
import net.sixik.sdmuilibrary.client.integration.imgui.IRenderable;
import net.sixik.sdmuilibrary.client.integration.imgui.init.FontAwesomeIcons;
import net.sixik.sdmuilibrary.client.integration.imgui.init.ImGuiBuffers;
import org.lwjgl.glfw.GLFW;

public class ImGuiHandler {
    public static final ImGuiHandler INSTANCE = new ImGuiHandler();
    private final ImGuiImplGlfw imGuiImplGlfw = new ImGuiImplGlfw();
    private final ImGuiImplGl3 imGuiImplGl3 = new ImGuiImplGl3();
    public long windowHandle = 0L;
    private final List<IRenderable> frames = new ArrayList<IRenderable>();
    private boolean isInitialized = false;
    private boolean callbackInput = false;
    public static ImFont FONT;

    protected ImGuiHandler() {
    }

    public void setCallback(boolean value) {
        if (!this.isInitialized) {
            return;
        }
        if (value && !this.callbackInput) {
            this.imGuiImplGlfw.installCallbacks(this.windowHandle);
            this.callbackInput = true;
        } else if (!value && this.callbackInput) {
            this.imGuiImplGlfw.restoreCallbacks(this.windowHandle);
            this.callbackInput = false;
        }
    }

    public void onGlfwInit(long handle) {
        if (this.isInitialized) {
            return;
        }
        SDMUILibrary.LOGGER.info("Start Initialization ImGuiHandler...");
        this.initializeImGui(handle);
        SDMUILibrary.LOGGER.info("Initialization ImGui Glfw!");
        this.imGuiImplGlfw.init(handle, false);
        if (!Minecraft.ON_OSX) {
            this.imGuiImplGl3.init("#version 430");
        } else {
            this.imGuiImplGl3.init("#version 120");
        }
        SDMUILibrary.LOGGER.info("Create ImNodes Context!");
        ImNodes.createContext();
        ImGui.styleColorsDark();
        this.windowHandle = handle;
        SDMUILibrary.LOGGER.info("Initializing ImGui Complete! WindowHandler: {}", (Object)this.windowHandle);
        RenderSystem.recordRenderCall(() -> this.drawFrame(0, new IRenderable(this){

            @Override
            public void renderImGui(int imGuiFlags, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                SDMUILibrary.LOGGER.info("ImGui successfully loaded!");
            }
        }, null, 0, 0, 0.0f));
        this.isInitialized = true;
    }

    private void initializeImGui(long glHandle) {
        ImGui.createContext();
        SDMUILibrary.LOGGER.info("ImGui context created!");
        ImGuiIO io = ImGui.getIO();
        io.setIniFilename(null);
        io.addBackendFlags(4);
        io.setConfigViewportsNoTaskBarIcon(true);
        io.addConfigFlags(1);
        io.addConfigFlags(64);
        this.initFonts(io);
        SDMUILibrary.LOGGER.info("ImGui Fonts initialized!");
        if (io.hasConfigFlags(1024)) {
            ImGuiStyle style = ImGui.getStyle();
            style.setWindowRounding(0.0f);
            style.setColor(2, ImGui.getColorU32((int)2, (float)1.0f));
        }
        SDMUILibrary.LOGGER.info("Main initialization complete!");
    }

    private void initFonts(ImGuiIO io) {
        ImFontGlyphRangesBuilder rangesBuilder = new ImFontGlyphRangesBuilder();
        rangesBuilder.addRanges(io.getFonts().getGlyphRangesDefault());
        rangesBuilder.addRanges(io.getFonts().getGlyphRangesCyrillic());
        rangesBuilder.addRanges(io.getFonts().getGlyphRangesJapanese());
        rangesBuilder.addRanges(FontAwesomeIcons._IconRange);
        ImFontConfig fontConfig = new ImFontConfig();
        fontConfig.setOversampleH(4);
        fontConfig.setOversampleV(4);
        fontConfig.setPixelSnapH(true);
        short[] glyphRanges = rangesBuilder.buildRanges();
        byte[] data = ImGuiHandler.readResourceBytes(ResourceLocation.tryBuild((String)"sdm_ui_library", (String)"fonts/perfectdosvga437.ttf"));
        FONT = data.length == 0 ? io.getFonts().addFontDefault() : io.getFonts().addFontFromMemoryTTF(data, 18.0f, fontConfig, glyphRanges);
        io.getFonts().build();
        fontConfig.destroy();
    }

    public void addFrame(IRenderable frame) {
        this.frames.add(frame);
    }

    public void addFrame(IRenderable ... frame) {
        this.frames.addAll(List.of(frame));
    }

    public void addFrame(Collection<IRenderable> frame) {
        this.frames.addAll(frame);
    }

    public void drawFrame(int imGuiFlags, IRenderable renderable, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ImGuiBuffers.getBuffer().clear(Minecraft.ON_OSX);
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
        GLFW.glfwSwapInterval((int)1);
        this.imGuiImplGl3.newFrame();
        this.imGuiImplGlfw.newFrame();
        ImGui.newFrame();
        ImGui.setNextWindowViewport((int)ImGui.getMainViewport().getID());
        renderable.renderImGui(imGuiFlags, guiGraphics, mouseX, mouseY, partialTick);
        this.endFrame();
    }

    public void drawFrames(int imGuiFlags, Collection<IRenderable> renderable, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (renderable.isEmpty()) {
            return;
        }
        ImGuiBuffers.getBuffer().clear(Minecraft.ON_OSX);
        Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
        this.imGuiImplGl3.newFrame();
        this.imGuiImplGlfw.newFrame();
        ImGui.newFrame();
        ImGui.setNextWindowViewport((int)ImGui.getMainViewport().getID());
        renderable.forEach(frame -> frame.renderImGui(imGuiFlags, guiGraphics, mouseX, mouseY, partialTick));
        this.endFrame();
    }

    private void endFrame() {
        ImGui.render();
        this.imGuiImplGl3.renderDrawData(ImGui.getDrawData());
        if (ImGui.getIO().hasConfigFlags(1024)) {
            long backupWindowPtr = GLFW.glfwGetCurrentContext();
            ImGui.updatePlatformWindows();
            ImGui.renderPlatformWindowsDefault();
            GLFW.glfwMakeContextCurrent((long)backupWindowPtr);
        }
    }

    public static byte[] readResourceBytes(ResourceLocation resourceLocation) {
        try {
            Optional resource = Minecraft.getInstance().getResourceManager().getResource(resourceLocation);
            if (resource.isEmpty()) {
                return new byte[0];
            }
            return ((Resource)resource.get()).open().readAllBytes();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static void loadFileFromAssets(String modid, String fileName) {
        ResourceLocation resourceLocation = ResourceLocation.tryBuild((String)modid, (String)fileName);
        try {
            String line;
            Optional resource = Minecraft.getInstance().getResourceManager().getResource(resourceLocation);
            BufferedReader reader = new BufferedReader(new InputStreamReader(((Resource)resource.get()).open(), StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

