/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.integration.imgui.extern;

import imgui.ImGui;
import imgui.type.ImDouble;
import imgui.type.ImFloat;
import imgui.type.ImInt;
import imgui.type.ImLong;
import imgui.type.ImString;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.sixik.sdmuilibrary.client.integration.imgui.extern.BTSImGui;

public class TagEditor<T extends Tag> {
    private static final int BUFFER_SIZE = 512;
    private final String name;
    private final T tag;
    private final Consumer<T> consumer;
    private boolean valueChanged = false;
    private ListTag currentListTag = null;

    public TagEditor(String name, T tag, Consumer<T> consumer) {
        this.name = name;
        this.tag = tag;
        this.consumer = consumer;
    }

    public boolean edit() {
        return switch (this.tag.getId()) {
            case 1 -> this.editByteTag();
            case 2 -> this.editShortTag();
            case 3 -> this.editIntTag();
            case 4 -> this.editLongTag();
            case 5 -> this.editFloatTag();
            case 6 -> this.editDoubleTag();
            case 7 -> this.editByteArrayTag();
            case 8 -> this.editStringTag();
            case 9 -> this.editListTag();
            case 10 -> this.editCompoundTag();
            case 11 -> this.editIntArrayTag();
            case 12 -> this.editLongArrayTag();
            default -> false;
        };
    }

    private boolean editByteTag() {
        ByteTag byteTag = (ByteTag)this.tag;
        ImInt value = new ImInt((int)byteTag.getAsByte());
        if (this.handleIntInput("Byte", value)) {
            int clampedValue = Math.min(Math.max(value.get(), -128), 127);
            this.consumer.accept(ByteTag.valueOf((byte)((byte)clampedValue)));
            return true;
        }
        return false;
    }

    private boolean editShortTag() {
        ShortTag shortTag = (ShortTag)this.tag;
        ImInt value = new ImInt((int)shortTag.getAsShort());
        if (this.handleIntInput("Short", value)) {
            int clampedValue = Math.min(Math.max(value.get(), Short.MIN_VALUE), Short.MAX_VALUE);
            this.consumer.accept(ShortTag.valueOf((short)((short)clampedValue)));
            return true;
        }
        return false;
    }

    private boolean editIntTag() {
        IntTag intTag = (IntTag)this.tag;
        ImInt value = new ImInt(intTag.getAsInt());
        if (this.handleIntInput("Int", value)) {
            this.consumer.accept(IntTag.valueOf((int)value.get()));
            return true;
        }
        return false;
    }

    private boolean editLongTag() {
        LongTag longTag = (LongTag)this.tag;
        ImLong value = new ImLong(longTag.getAsLong());
        if (ImGui.inputScalar((String)this.name, (ImLong)value)) {
            this.consumer.accept(LongTag.valueOf((long)value.get()));
            return true;
        }
        this.setTooltipIfHovered("Long");
        return false;
    }

    private boolean editFloatTag() {
        FloatTag floatTag = (FloatTag)this.tag;
        ImFloat value = new ImFloat(floatTag.getAsFloat());
        if (ImGui.inputFloat((String)this.name, (ImFloat)value)) {
            this.consumer.accept(FloatTag.valueOf((float)value.get()));
            return true;
        }
        this.setTooltipIfHovered("Float");
        return false;
    }

    private boolean editDoubleTag() {
        DoubleTag doubleTag = (DoubleTag)this.tag;
        ImDouble value = new ImDouble(doubleTag.getAsDouble());
        if (ImGui.inputDouble((String)this.name, (ImDouble)value)) {
            this.consumer.accept(DoubleTag.valueOf((double)value.get()));
            return true;
        }
        this.setTooltipIfHovered("Double");
        return false;
    }

    private boolean editStringTag() {
        StringTag stringTag = (StringTag)this.tag;
        ImString value = new ImString(stringTag.getAsString(), 512);
        if (ImGui.inputText((String)this.name, (ImString)value)) {
            this.consumer.accept(StringTag.valueOf((String)value.get()));
            return true;
        }
        this.setTooltipIfHovered("String");
        return false;
    }

    private boolean editByteArrayTag() {
        return this.editArrayTag((CollectionTag)((ByteArrayTag)this.tag), "Byte Array");
    }

    private boolean editIntArrayTag() {
        return this.editArrayTag((CollectionTag)((IntArrayTag)this.tag), "Int Array");
    }

    private boolean editLongArrayTag() {
        return this.editArrayTag((CollectionTag)((LongArrayTag)this.tag), "Long Array");
    }

    private boolean editListTag() {
        this.currentListTag = (ListTag)this.tag;
        boolean result = this.editCollectionTag((CollectionTag)this.currentListTag, "List");
        this.currentListTag = null;
        return result;
    }

    private boolean editCompoundTag() {
        CompoundTag compoundTag = (CompoundTag)this.tag;
        ImGui.pushID((String)(this.name + "_compoundTag"));
        boolean value = ImGui.treeNode((String)this.name);
        this.setTooltipIfHovered("CompoundTag");
        if (value) {
            for (String key : compoundTag.getAllKeys()) {
                if (!BTSImGui.beginEditElementTag(key, compoundTag.get(key), s -> {
                    compoundTag.put(key, s);
                    this.consumer.accept(compoundTag);
                })) continue;
                this.valueChanged = true;
            }
            ImGui.treePop();
        }
        ImGui.popID();
        return this.valueChanged;
    }

    private <S extends Tag> boolean editArrayTag(CollectionTag<S> arrayTag, String tooltip) {
        int i;
        ImGui.pushID((String)(this.name + "_" + tooltip.replace(" ", "")));
        ArrayList<Integer> indicesToRemove = new ArrayList<Integer>();
        boolean value = ImGui.treeNode((String)this.name);
        this.setTooltipIfHovered(tooltip);
        if (value) {
            for (i = 0; i < arrayTag.size(); ++i) {
                int finalI = i;
                if (BTSImGui.beginEditElementTag(String.valueOf(i), (Tag)arrayTag.get(i), s -> {
                    arrayTag.set(finalI, s);
                    this.consumer.accept(arrayTag);
                })) {
                    this.valueChanged = true;
                }
                this.handleItemContextMenu(arrayTag, i, indicesToRemove);
            }
            ImGui.treePop();
        }
        ImGui.popID();
        for (i = indicesToRemove.size() - 1; i >= 0; --i) {
            arrayTag.remove(((Integer)indicesToRemove.get(i)).intValue());
            this.valueChanged = true;
        }
        if (this.valueChanged) {
            this.consumer.accept(arrayTag);
        }
        return this.valueChanged;
    }

    private <S extends Tag> boolean editCollectionTag(CollectionTag<S> collectionTag, String tooltip) {
        int i;
        ImGui.pushID((String)(this.name + "_" + tooltip.replace(" ", "")));
        ArrayList<Integer> indicesToRemove = new ArrayList<Integer>();
        boolean value = ImGui.treeNode((String)this.name);
        this.setTooltipIfHovered(tooltip);
        if (value) {
            for (i = 0; i < collectionTag.size(); ++i) {
                int finalI = i;
                if (BTSImGui.beginEditElementTag(String.valueOf(i), (Tag)collectionTag.get(i), s -> {
                    collectionTag.set(finalI, s);
                    this.consumer.accept(collectionTag);
                })) {
                    this.valueChanged = true;
                }
                this.handleItemContextMenu(collectionTag, i, indicesToRemove);
            }
            ImGui.treePop();
        }
        ImGui.popID();
        for (i = indicesToRemove.size() - 1; i >= 0; --i) {
            collectionTag.remove(((Integer)indicesToRemove.get(i)).intValue());
            this.valueChanged = true;
        }
        if (this.valueChanged) {
            this.consumer.accept(collectionTag);
        }
        return this.valueChanged;
    }

    private <S extends Tag> void handleItemContextMenu(CollectionTag<S> collectionTag, int index, List<Integer> indicesToRemove) {
        if (ImGui.beginPopupContextItem((String)("context_" + index + "_" + this.name))) {
            if (ImGui.beginMenu((String)"\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c")) {
                if (collectionTag instanceof ByteArrayTag) {
                    if (ImGui.menuItem((String)"Byte")) {
                        collectionTag.add((Object)ByteTag.valueOf((byte)0));
                        this.valueChanged = true;
                    }
                } else if (collectionTag instanceof IntArrayTag) {
                    if (ImGui.menuItem((String)"Int")) {
                        collectionTag.add((Object)IntTag.valueOf((int)0));
                        this.valueChanged = true;
                    }
                } else if (collectionTag instanceof LongArrayTag) {
                    if (ImGui.menuItem((String)"Long")) {
                        collectionTag.add((Object)LongTag.valueOf((long)0L));
                        this.valueChanged = true;
                    }
                } else if (collectionTag instanceof ListTag) {
                    ListTag listTag = (ListTag)collectionTag;
                    if (listTag.getElementType() == 0) {
                        if (ImGui.menuItem((String)"Byte")) {
                            this.addElementToCollection(collectionTag, (Tag)ByteTag.valueOf((byte)0));
                        }
                        if (ImGui.menuItem((String)"Short")) {
                            this.addElementToCollection(collectionTag, (Tag)ShortTag.valueOf((short)0));
                        }
                        if (ImGui.menuItem((String)"Int")) {
                            this.addElementToCollection(collectionTag, (Tag)IntTag.valueOf((int)0));
                        }
                        if (ImGui.menuItem((String)"Long")) {
                            this.addElementToCollection(collectionTag, (Tag)LongTag.valueOf((long)0L));
                        }
                        if (ImGui.menuItem((String)"Float")) {
                            this.addElementToCollection(collectionTag, (Tag)FloatTag.valueOf((float)0.0f));
                        }
                        if (ImGui.menuItem((String)"Double")) {
                            this.addElementToCollection(collectionTag, (Tag)DoubleTag.valueOf((double)0.0));
                        }
                        if (ImGui.menuItem((String)"String")) {
                            this.addElementToCollection(collectionTag, (Tag)StringTag.valueOf((String)""));
                        }
                        if (ImGui.menuItem((String)"CompoundTag")) {
                            this.addElementToCollection(collectionTag, (Tag)new CompoundTag());
                        }
                        if (ImGui.menuItem((String)"List")) {
                            this.addElementToCollection(collectionTag, (Tag)new ListTag());
                        }
                        if (ImGui.menuItem((String)"Byte Array")) {
                            this.addElementToCollection(collectionTag, (Tag)new ByteArrayTag(new ArrayList()));
                        }
                        if (ImGui.menuItem((String)"Int Array")) {
                            this.addElementToCollection(collectionTag, (Tag)new IntArrayTag(new ArrayList()));
                        }
                        if (ImGui.menuItem((String)"Long Array")) {
                            this.addElementToCollection(collectionTag, (Tag)new LongArrayTag(new ArrayList()));
                        }
                    } else {
                        switch (listTag.getElementType()) {
                            case 1: {
                                if (!ImGui.menuItem((String)"Byte")) break;
                                this.addElementToCollection(collectionTag, (Tag)ByteTag.valueOf((byte)0));
                                break;
                            }
                            case 2: {
                                if (!ImGui.menuItem((String)"Short")) break;
                                this.addElementToCollection(collectionTag, (Tag)ShortTag.valueOf((short)0));
                                break;
                            }
                            case 3: {
                                if (!ImGui.menuItem((String)"Int")) break;
                                this.addElementToCollection(collectionTag, (Tag)IntTag.valueOf((int)0));
                                break;
                            }
                            case 4: {
                                if (!ImGui.menuItem((String)"Long")) break;
                                this.addElementToCollection(collectionTag, (Tag)LongTag.valueOf((long)0L));
                                break;
                            }
                            case 5: {
                                if (!ImGui.menuItem((String)"Float")) break;
                                this.addElementToCollection(collectionTag, (Tag)FloatTag.valueOf((float)0.0f));
                                break;
                            }
                            case 6: {
                                if (!ImGui.menuItem((String)"Double")) break;
                                this.addElementToCollection(collectionTag, (Tag)DoubleTag.valueOf((double)0.0));
                                break;
                            }
                            case 7: {
                                if (!ImGui.menuItem((String)"Byte Array")) break;
                                this.addElementToCollection(collectionTag, (Tag)new ByteArrayTag(new ArrayList()));
                                break;
                            }
                            case 8: {
                                if (!ImGui.menuItem((String)"String")) break;
                                this.addElementToCollection(collectionTag, (Tag)StringTag.valueOf((String)""));
                                break;
                            }
                            case 9: {
                                if (!ImGui.menuItem((String)"List")) break;
                                this.addElementToCollection(collectionTag, (Tag)new ListTag());
                                break;
                            }
                            case 10: {
                                if (!ImGui.menuItem((String)"CompoundTag")) break;
                                this.addElementToCollection(collectionTag, (Tag)new CompoundTag());
                                break;
                            }
                            case 11: {
                                if (!ImGui.menuItem((String)"Int Array")) break;
                                this.addElementToCollection(collectionTag, (Tag)new IntArrayTag(new ArrayList()));
                                break;
                            }
                            case 12: {
                                if (!ImGui.menuItem((String)"Long Array")) break;
                                this.addElementToCollection(collectionTag, (Tag)new LongArrayTag(new ArrayList()));
                                break;
                            }
                        }
                    }
                }
                ImGui.endMenu();
            }
            if (ImGui.menuItem((String)"\u0423\u0434\u0430\u043b\u0438\u0442\u044c")) {
                indicesToRemove.add(index);
            }
            ImGui.endPopup();
        }
    }

    private <S extends Tag> void addElementToCollection(CollectionTag<S> collectionTag, Tag newTag) {
        if (collectionTag instanceof ListTag) {
            collectionTag.add((Object)newTag);
            this.valueChanged = true;
            this.consumer.accept(collectionTag);
        }
    }

    private boolean handleIntInput(String tooltip, ImInt value) {
        if (ImGui.inputInt((String)this.name, (ImInt)value)) {
            return true;
        }
        this.setTooltipIfHovered(tooltip);
        return false;
    }

    private void setTooltipIfHovered(String tooltip) {
        if (ImGui.isItemHovered()) {
            ImGui.setTooltip((String)tooltip);
        }
    }
}

