/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.integration.imgui;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.sixik.sdmuilibrary.client.integration.imgui.IRenderable;
import net.sixik.sdmuilibrary.client.integration.imgui.init.ImGuiBuffers;
import net.sixik.sdmuilibrary.client.integration.imgui.init.ImGuiHandler;

public class ImGuiOverlayWrapper {
    private static Map<String, IRenderable> OVERLAY_ELEMENTS = new HashMap<String, IRenderable>();
    private static final int IMGUI_FLAG = 786944;

    public static void addOverlayElement(String id, IRenderable element) {
        Window window = Minecraft.getInstance().getWindow();
        TextureTarget framebuffer = ImGuiBuffers.imguiOverlayBuffer;
        if (framebuffer.width != window.getWidth() || framebuffer.height != window.getHeight()) {
            framebuffer.resize(window.getWidth(), window.getHeight(), Minecraft.ON_OSX);
        }
        OVERLAY_ELEMENTS.put(id, element);
    }

    public static void removeOverlayElement(String id) {
        OVERLAY_ELEMENTS.remove(id);
    }

    public static IRenderable getByID(String id) {
        return OVERLAY_ELEMENTS.get(id);
    }

    public static void renderAll(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (OVERLAY_ELEMENTS.isEmpty()) {
            return;
        }
        guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
        ImGuiBuffers.setBuffer(ImGuiBuffers.Type.OVERLAY);
        ImGuiHandler.INSTANCE.drawFrames(786944, OVERLAY_ELEMENTS.values(), guiGraphics, mouseX, mouseY, partialTick);
    }
}

