/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.integration.imgui;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import imgui.ImDrawList;
import imgui.ImGui;
import imgui.ImVec2;
import imgui.type.ImBoolean;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmuilibrary.client.integration.imgui.init.ImGuiBuffers;
import net.sixik.sdmuilibrary.client.integration.imgui.struct.ImGuiStructs;
import net.sixik.sdmuilibrary.client.integration.imgui.utils.ImGuiGLRenderHelper;
import net.sixik.sdmuilibrary.client.utils.misc.RGBA;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import oshi.util.tuples.Pair;

public class ImGuiExtension {
    public static void createID(String id, Runnable runnable) {
        ImGui.pushID((String)id);
        runnable.run();
        ImGui.popID();
    }

    public static void comboBoxList(String id, int currentValue, Collection<String> array, Consumer<ImGuiStructs.ComboBox> onSelected) {
        ImGuiExtension.comboBoxList(id, 0, currentValue, array, onSelected);
    }

    public static void comboBoxList(String id, int imGuiComboFlags, int currentValue, Collection<String> array, Consumer<ImGuiStructs.ComboBox> onSelected) {
        ImGuiExtension.comboBoxList(id, currentValue, imGuiComboFlags, array.toArray(new String[0]), onSelected);
    }

    public static void comboBoxList(String id, int currentValue, String[] array, Consumer<ImGuiStructs.ComboBox> onSelected) {
        ImGuiExtension.comboBoxList(id, 0, currentValue, array, onSelected);
    }

    public static void comboBoxList(String id, int imGuiComboFlags, int currentValue, String[] array, Consumer<ImGuiStructs.ComboBox> onSelected) {
        String d = "NULL";
        int currentItem = -1;
        if (currentValue >= 0 && currentValue < array.length) {
            d = array[currentValue];
            currentItem = currentValue;
        }
        if (ImGui.beginCombo((String)id, (String)d, (int)imGuiComboFlags)) {
            for (int i = 0; i < array.length; ++i) {
                boolean s;
                if (array[i] == null) continue;
                boolean bl = s = currentItem == i;
                if (ImGui.selectable((String)array[i], (boolean)s)) {
                    currentItem = i;
                    if (onSelected != null) {
                        onSelected.accept(new ImGuiStructs.ComboBox(array[i], i));
                    }
                }
                if (!s) continue;
                ImGui.setItemDefaultFocus();
            }
            ImGui.endCombo();
        }
    }

    public static void comboBoxListWithTooltip(String id, String currentKey, Map<String, Runnable> valueMap, Consumer<ImGuiStructs.ComboBox> onSelected) {
        ImGuiExtension.comboBoxListWithTooltip(id, 0, currentKey, valueMap, onSelected);
    }

    public static void comboBoxListWithTooltip(String id, int imGuiComboFlags, String currentKey, Map<String, Runnable> valueMap, Consumer<ImGuiStructs.ComboBox> onSelected) {
        int i;
        String d = "NULL";
        int currentItem = -1;
        Runnable[] tooltips = valueMap.values().toArray(new Runnable[0]);
        String[] array = valueMap.keySet().toArray(new String[0]);
        for (i = 0; i < array.length; ++i) {
            if (!currentKey.equals(array[i])) continue;
            d = array[i];
            currentItem = i;
            break;
        }
        if (ImGui.beginCombo((String)id, (String)d, (int)imGuiComboFlags)) {
            for (i = 0; i < array.length; ++i) {
                boolean s;
                if (array[i] == null) continue;
                boolean bl = s = currentItem == i;
                if (ImGui.selectable((String)array[i], (boolean)s)) {
                    currentItem = i;
                    if (onSelected != null) {
                        onSelected.accept(new ImGuiStructs.ComboBox(array[i], i));
                    }
                }
                if (tooltips[i] != null && ImGui.isItemHovered()) {
                    tooltips[i].run();
                }
                if (!s) continue;
                ImGui.setItemDefaultFocus();
            }
            ImGui.endCombo();
        }
    }

    public static void toolBar(String id, Runnable codeBlock) {
        ImGui.pushID((String)id);
        codeBlock.run();
        ImGui.popID();
    }

    public static void toolBarItem(Runnable codeBlock) {
        ImGui.beginGroup();
        codeBlock.run();
        ImGui.endGroup();
    }

    public static void toolBarItemLine(Runnable codeBlock) {
        ImGui.sameLine();
        ImGui.beginGroup();
        codeBlock.run();
        ImGui.endGroup();
    }

    public static void collapseGroup(String id, Runnable codeBlock) {
        ImGuiExtension.collapseGroup(id, 0, codeBlock);
    }

    public static void collapseGroup(String id, int imGuiTreeNodeFlags, Runnable codeBlock) {
        if (ImGui.collapsingHeader((String)id, (int)imGuiTreeNodeFlags)) {
            codeBlock.run();
        }
    }

    public static void collapseGroup(String id, ImBoolean collapsed, Runnable codeBlock) {
        ImGuiExtension.collapseGroup(id, collapsed, 0, codeBlock);
    }

    public static void collapseGroup(String id, ImBoolean collapsed, int imGuiTreeNodeFlags, Runnable codeBlock) {
        if (ImGui.collapsingHeader((String)id, (ImBoolean)new ImBoolean(collapsed), (int)imGuiTreeNodeFlags)) {
            codeBlock.run();
        }
    }

    public static void simpleTooltip(String tooltip, Runnable toAdd) {
        toAdd.run();
        if (ImGui.isItemHovered()) {
            ImGui.setTooltip((String)tooltip);
        }
    }

    public static void advancedTooltip(Runnable codeBlock, Runnable toAdd) {
        toAdd.run();
        if (ImGui.isItemHovered()) {
            ImGui.beginTooltip();
            codeBlock.run();
            ImGui.endTooltip();
        }
    }

    public static void advancedTooltip(Runnable codeBlock) {
        if (ImGui.isItemHovered()) {
            ImGui.beginTooltip();
            codeBlock.run();
            ImGui.endTooltip();
        }
    }

    public static boolean drawItem(String name, ItemStack item, float width, float height) {
        return ImGuiExtension.drawItem(name, item, width, height, 0);
    }

    public static boolean drawItem(String name, ItemStack item, float width, float height, int imGuiBTSFlags) {
        return ImGuiExtension.drawItem(name, item, width, height, 1.0f, 0.0f, imGuiBTSFlags, RGBA.DEFAULT);
    }

    public static boolean drawItem(String name, ItemStack item, float width, float height, float scale, float rotation, int imGuiBTSFlags, RGBA color) {
        ImGui.pushID((String)name);
        ImVec2 cPos = ImGui.getCursorPos();
        boolean clicked = ImGuiExtension.drawMcRender(width, height, imGuiBTSFlags, color, (cursor, hovered) -> {
            PoseStack stack = new PoseStack();
            if ((imGuiBTSFlags & 1) != 0) {
                stack.translate(0.0f, 0.0f, 200.0f);
            }
            stack.pushPose();
            ImGuiGLRenderHelper.renderItemStack(item, stack, cursor.x, cursor.y, width, height, (hovered != false || (imGuiBTSFlags & 4) == 0 ? 1.0f : 0.9f) * scale, rotation);
            stack.popPose();
            ImGuiGLRenderHelper.renderItemDecorations(item, stack, (int)cursor.x, (int)cursor.y, width, height);
        });
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return false;
        }
        ImVec2 pos = ImGui.getCursorScreenPos();
        if (ImGui.isMouseHoveringRect((float)pos.x, (float)pos.y, (float)(pos.x + width), (float)(pos.y + height)) && !item.isEmpty() && (imGuiBTSFlags & 5) == 0) {
            ImGui.pushStyleVar((int)2, (float)0.0f, (float)0.0f);
            ImGui.pushStyleVar((int)3, (float)0.0f);
            ImGui.pushStyleVar((int)10, (float)0.0f);
            ImGui.pushStyleColor((int)5, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ImGui.pushStyleColor((int)4, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            ImGui.popStyleColor((int)2);
            ImGui.popStyleVar((int)3);
        }
        if ((imGuiBTSFlags & 1) == 0) {
            ImGui.setCursorPos((float)cPos.x, (float)cPos.y);
            ImGui.dummy((float)width, (float)height);
        }
        ImGui.popID();
        return clicked;
    }

    public static boolean drawMcRender(float width, float height, int imGuiBTSFlags, RGBA color, BiConsumer<ImVec2, Boolean> render) {
        RenderTarget mcBuffer = Minecraft.getInstance().getMainRenderTarget();
        mcBuffer.unbindWrite();
        TextureTarget buffer = ImGuiBuffers.getBuffer();
        buffer.bindWrite(true);
        ImVec2 cursorPos = ImGui.getCursorScreenPos();
        Window window = Minecraft.getInstance().getWindow();
        boolean isHovered = ImGui.isMouseHoveringRect((float)cursorPos.x, (float)cursorPos.y, (float)(cursorPos.x + width), (float)(cursorPos.y + height));
        boolean isClicked = isHovered && ImGui.isMouseClicked((int)0);
        RenderSystem.backupProjectionMatrix();
        if ((imGuiBTSFlags & 6) != 0) {
            RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)((double)window.getWidth() / window.getGuiScale()), (float)((double)window.getHeight() / window.getGuiScale()), 0.0f, 1000.0f, 3000.0f), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        } else {
            RenderSystem.setProjectionMatrix((Matrix4f)new Matrix4f().setOrtho(0.0f, (float)buffer.width, (float)buffer.height, 0.0f, 1000.0f, 3000.0f), (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        }
        Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
        matrix4fstack.pushMatrix();
        matrix4fstack.translate(0.0f, 0.0f, -2000.0f);
        RenderSystem.applyModelViewMatrix();
        if ((imGuiBTSFlags & 3) != 0) {
            RenderSystem.enableScissor((int)((int)cursorPos.x), (int)((int)((float)buffer.height - cursorPos.y - height)), (int)((int)width), (int)((int)height));
        }
        RenderSystem.enableDepthTest();
        render.accept(cursorPos, isHovered);
        if ((imGuiBTSFlags & 3) != 0) {
            RenderSystem.disableScissor();
        }
        RenderSystem.restoreProjectionMatrix();
        matrix4fstack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        buffer.unbindWrite();
        mcBuffer.bindWrite(true);
        float u0 = cursorPos.x / (float)buffer.width;
        float u1 = (cursorPos.x + width) / (float)buffer.width;
        float v0 = 1.0f - cursorPos.y / (float)buffer.height;
        float v1 = 1.0f - (cursorPos.y + height) / (float)buffer.height;
        ImDrawList list = (imGuiBTSFlags & 1) != 0 ? ImGui.getForegroundDrawList() : ImGui.getWindowDrawList();
        ImVec2 cursor = ImGui.getCursorScreenPos();
        ImGuiExtension.pushStyle(List.of(new Pair((Object)21, (Object)ImGui.colorConvertFloat4ToU32((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f)), new Pair((Object)23, (Object)ImGui.colorConvertFloat4ToU32((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f)), new Pair((Object)22, (Object)ImGui.colorConvertFloat4ToU32((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f))), () -> {
            list.addImage((long)buffer.getColorTextureId(), cursor.x, cursor.y, cursor.x + width, cursor.y + height, u0, v0, u1, v1, color.toInt());
            if ((imGuiBTSFlags & 2) != 0) {
                list.addRect(cursor.x, cursor.y, cursor.x + width, cursor.y + height, -1);
            }
        });
        return isClicked;
    }

    private static void tooltip(Runnable runnable) {
        ImGui.beginTooltip();
        runnable.run();
        ImGui.endTooltip();
    }

    private static void pushStyle(Collection<Pair<Integer, Integer>> styles, Runnable runnable) {
        styles.forEach(style -> ImGui.pushStyleColor((int)((Integer)style.getA()), (int)((Integer)style.getB())));
        runnable.run();
        ImGui.popStyleColor((int)styles.size());
    }

    public static double getGuiScale() {
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        return window.getGuiScale();
    }

    @Deprecated
    public static boolean drawOpenGL(float width, float height, int imGuiBTSFlags, RGBA color, BiConsumer<ImVec2, Boolean> render) {
        RenderTarget mcBuffer = Minecraft.getInstance().getMainRenderTarget();
        mcBuffer.unbindWrite();
        int framebuffer = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer((int)36160, (int)framebuffer);
        int texture = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)texture);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)((int)width), (int)((int)height), (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texture, (int)0);
        int depthBuffer = GL30.glGenRenderbuffers();
        GL30.glBindRenderbuffer((int)36161, (int)depthBuffer);
        GL30.glRenderbufferStorage((int)36161, (int)6402, (int)((int)width), (int)((int)height));
        GL30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)depthBuffer);
        if (GL30.glCheckFramebufferStatus((int)36160) != 36053) {
            throw new RuntimeException("Framebuffer is not complete!");
        }
        GL30.glBindFramebuffer((int)36160, (int)framebuffer);
        GL11.glViewport((int)0, (int)0, (int)((int)width), (int)((int)height));
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)width, (double)height, (double)0.0, (double)-1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        if ((imGuiBTSFlags & 3) != 0) {
            GL30.glEnable((int)3089);
            GL30.glScissor((int)0, (int)0, (int)((int)width), (int)((int)height));
        }
        ImVec2 cursorPos = ImGui.getCursorScreenPos();
        boolean isHovered = ImGui.isMouseHoveringRect((float)cursorPos.x, (float)cursorPos.y, (float)(cursorPos.x + width), (float)(cursorPos.y + height));
        boolean isClicked = isHovered && ImGui.isMouseClicked((int)0);
        render.accept(cursorPos, isHovered);
        if ((imGuiBTSFlags & 3) != 0) {
            GL30.glDisable((int)3089);
        }
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL30.glBindFramebuffer((int)36160, (int)0);
        ImDrawList drawList = ImGui.getWindowDrawList();
        drawList.addImage((long)texture, cursorPos.x, cursorPos.y, cursorPos.x + width, cursorPos.y + height, 0.0f, 0.0f, 1.0f, 1.0f, color.toInt());
        GL30.glDeleteFramebuffers((int)framebuffer);
        GL30.glDeleteTextures((int)texture);
        GL30.glDeleteRenderbuffers((int)depthBuffer);
        return isClicked;
    }
}

