/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.integration.imgui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.sixik.sdmuilibrary.client.integration.imgui.ImGuiOverlayWrapper;
import net.sixik.sdmuilibrary.client.integration.imgui.ImGuiScreenWrapper;
import net.sixik.sdmuilibrary.client.integration.imgui.init.ImGuiBuffers;

public interface IRenderable {
    default public void draw(GuiGraphics graphics, int x, int y, int width, int height) {
    }

    default public void renderImGui(int imGuiFlags, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    default public void openScreenImGui() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> Minecraft.getInstance().setScreen((Screen)new ImGuiScreenWrapper(this)));
        } else {
            Minecraft.getInstance().setScreen((Screen)new ImGuiScreenWrapper(this));
        }
    }

    default public void addToOverlay(String id) {
        ImGuiOverlayWrapper.addOverlayElement(id, this);
    }

    default public void removeFromOverlay(String id) {
        ImGuiOverlayWrapper.removeOverlayElement(id);
    }

    default public void renderOnScreen(Class<?> cls) {
        List list = ImGuiBuffers.SCREEN_RENDERS.getOrDefault(cls, new ArrayList());
        list.add(this);
        ImGuiBuffers.SCREEN_RENDERS.put(cls, list);
    }

    default public void closeOnScreen(Class<?> cls) {
        List list = ImGuiBuffers.SCREEN_RENDERS.getOrDefault(cls, new ArrayList());
        list.remove(this);
        ImGuiBuffers.SCREEN_RENDERS.put(cls, list);
    }
}

