/*
 * Decompiled with CFR 0.152.
 */
package net.createcobblestone.neoforge;

import com.simibubi.create.foundation.data.CreateRegistrate;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.createcobblestone.neoforge.blocks.MechanicalGeneratorBlockEntity;
import net.createcobblestone.neoforge.data.GeneratorTypeLoader;
import net.createcobblestone.neoforge.data.GeneratorTypesPayload;
import net.createcobblestone.neoforge.data.provider.MechanicalGeneratorLootTableProvider;
import net.createcobblestone.neoforge.data.provider.MechanicalGeneratorRecipeProvider;
import net.createcobblestone.neoforge.index.BlockEntities;
import net.createcobblestone.neoforge.index.Blocks;
import net.createcobblestone.neoforge.index.Config;
import net.createcobblestone.neoforge.index.CreativeTabs;
import net.createcobblestone.neoforge.index.Network;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(modid="createcobblestone")
@Mod(value="createcobblestone")
public class CreateCobblestoneNeoForge {
    public static final String MOD_ID = "createcobblestone";
    public static final String NAME = "Create cobblestone NeoForge";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Create cobblestone NeoForge");
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"createcobblestone");

    public CreateCobblestoneNeoForge(IEventBus eventBus, ModContainer modContainer) {
        LOGGER.info("{} initializing on platform: {}", (Object)NAME, (Object)"NeoForge");
        REGISTRATE.registerEventListeners(eventBus);
        CreativeTabs.register(eventBus);
        NeoForge.EVENT_BUS.addListener(this::onDatapackSyncEvent);
        Config.register(modContainer);
        Blocks.register();
        BlockEntities.register();
        GeneratorTypeLoader.register();
        eventBus.register(CreateCobblestoneNeoForge.class);
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    @SubscribeEvent
    public static void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput out = gen.getPackOutput();
        CompletableFuture loot = event.getLookupProvider();
        ExistingFileHelper efh = event.getExistingFileHelper();
        CompletableFuture registries = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new MechanicalGeneratorRecipeProvider(out, loot));
        gen.addProvider(event.includeServer(), (DataProvider)new MechanicalGeneratorLootTableProvider(out, registries));
    }

    @SubscribeEvent
    public static void onRegisterCapabilitiesEvent(RegisterCapabilitiesEvent event) {
        MechanicalGeneratorBlockEntity.registerCapabilities(event);
    }

    @SubscribeEvent
    public static void onModConfigLoadingEvent(ModConfigEvent.Loading event) {
        Config.onLoad(event.getConfig());
    }

    @SubscribeEvent
    public static void onModConfigReloadingEvent(ModConfigEvent.Reloading event) {
        Config.onReload(event.getConfig());
    }

    @SubscribeEvent
    public static void onRegisterPayloadsEvent(RegisterPayloadHandlersEvent event) {
        LOGGER.info("Registering packets for Create cobblestone NeoForge");
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(GeneratorTypesPayload.TYPE, GeneratorTypesPayload.STREAM_CODEC, Network::handleGeneratorTypesOnClient);
    }

    private void onDatapackSyncEvent(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            LOGGER.info("Syncing generator types to new client");
            GeneratorTypeLoader.sendGeneratorTypesToClient(Collections.singleton(event.getPlayer()));
        } else if (!event.getPlayerList().getPlayers().isEmpty()) {
            LOGGER.info("Syncing generator types to all clients");
            GeneratorTypeLoader.sendGeneratorTypesToClient(event.getPlayerList().getPlayers());
        } else {
            LOGGER.warn("Syncing generator types, but no players found");
        }
    }
}

