/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.features;

import com.blackgear.vanillabackport.common.level.blocks.LeafLitterBlock;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class LeafLitterFeature
extends Feature<NoneFeatureConfiguration> {
    public LeafLitterFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int xRange = 0; xRange < 16; ++xRange) {
            if (random.nextBoolean()) continue;
            for (int zRange = 0; zRange < 16; ++zRange) {
                if (random.nextBoolean()) continue;
                int x = origin.getX() + xRange;
                int z = origin.getZ() + zRange;
                mutable.set(x, level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z) - 1, z);
                if (!level.getBlockState((BlockPos)mutable).is(BlockTags.LEAVES) || !level.getBlockState((BlockPos)mutable).is(ModBlockTags.ALLOWS_LEAF_LITTER)) continue;
                mutable.set(x, level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z), z);
                BlockState state = (BlockState)((BlockState)ModBlocks.LEAF_LITTER.get().defaultBlockState().setValue((Property)LeafLitterBlock.AMOUNT, (Comparable)Integer.valueOf(random.nextIntBetweenInclusive(1, 4)))).setValue((Property)LeafLitterBlock.FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(random));
                if (level.getBlockState((BlockPos)mutable).is(ModBlocks.LEAF_LITTER.get()) || !level.getBlockState((BlockPos)mutable).isAir() || !state.canSurvive((LevelReader)level, (BlockPos)mutable)) continue;
                level.setBlock((BlockPos)mutable, state, 1);
            }
        }
        return true;
    }
}

