/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.crafttweaker;

import com.blakebr0.cucumber.helper.ParsingHelper;
import com.blakebr0.mysticalagriculture.api.crafting.IAwakeningRecipe;
import com.blakebr0.mysticalagriculture.crafting.EssenceVesselColorManager;
import com.blakebr0.mysticalagriculture.crafting.recipe.AwakeningRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.mysticalagriculture.AwakeningCrafting")
@ZenRegister
public final class AwakeningCrafting
implements IRecipeManager<IAwakeningRecipe> {
    public RecipeType<IAwakeningRecipe> getRecipeType() {
        return (RecipeType)ModRecipeTypes.AWAKENING.get();
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack output, IIngredient input, IIngredient[] inputs, IItemStack[] essences, @ZenCodeType.OptionalBoolean boolean transferComponents) {
        ResourceLocation id = CraftTweakerConstants.rl((String)this.fixRecipeName(name));
        AwakeningRecipe recipe = new AwakeningRecipe(input.asVanillaIngredient(), AwakeningCrafting.toIngredientsList(inputs), AwakeningCrafting.toItemStackList(essences), output.getInternal(), transferComponents);
        recipe.setTransformer((slot, stack) -> slot == 0 ? input.getRemainingItem((IItemStack)new MCItemStack(stack)).getInternal() : inputs[slot - 1].getRemainingItem((IItemStack)new MCItemStack(stack)).getInternal());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe)));
    }

    @ZenCodeType.Method
    public void setEssenceVesselColor(IItemStack stack, String color) {
        CraftTweakerAPI.apply((IAction)new SetEssenceVesselColorAction(stack, color));
    }

    private static NonNullList<Ingredient> toIngredientsList(IIngredient ... iingredients) {
        NonNullList ingredients = NonNullList.withSize((int)4, (Object)Ingredient.EMPTY);
        for (int i = 0; i < iingredients.length; ++i) {
            ingredients.set(i, (Object)iingredients[i].asVanillaIngredient());
        }
        return ingredients;
    }

    private static NonNullList<ItemStack> toItemStackList(IItemStack ... iitemStacks) {
        NonNullList itemStacks = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        for (int i = 0; i < iitemStacks.length; ++i) {
            itemStacks.set(i, (Object)iitemStacks[i].getInternal());
        }
        return itemStacks;
    }

    record SetEssenceVesselColorAction(IItemStack stack, String color) implements IRuntimeAction
    {
        public void apply() {
            EssenceVesselColorManager.INSTANCE.addColor(this.stack.getInternal(), ParsingHelper.parseHex((String)this.color, (String)this.color));
        }

        public String describe() {
            return "Setting the Essence Vessel color for the item %s to %s.".formatted(this.stack.getDisplayName().getString(), this.color);
        }

        public String systemName() {
            return "Mystical Agriculture";
        }
    }
}

