/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.crop;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import net.minecraft.resources.ResourceLocation;

public class CropTextures {
    public static final ResourceLocation FLOWER_INGOT_BLANK = MysticalAgricultureAPI.resource("block/flower_ingot");
    public static final ResourceLocation FLOWER_ROCK_BLANK = MysticalAgricultureAPI.resource("block/flower_rock");
    public static final ResourceLocation FLOWER_DUST_BLANK = MysticalAgricultureAPI.resource("block/flower_dust");
    public static final ResourceLocation FLOWER_FACE_BLANK = MysticalAgricultureAPI.resource("block/flower_face");
    public static final ResourceLocation ESSENCE_INGOT_BLANK = MysticalAgricultureAPI.resource("item/essence_ingot");
    public static final ResourceLocation ESSENCE_ROCK_BLANK = MysticalAgricultureAPI.resource("item/essence_rock");
    public static final ResourceLocation ESSENCE_DUST_BLANK = MysticalAgricultureAPI.resource("item/essence_dust");
    public static final ResourceLocation ESSENCE_GEM_BLANK = MysticalAgricultureAPI.resource("item/essence_gem");
    public static final ResourceLocation ESSENCE_TALL_GEM_BLANK = MysticalAgricultureAPI.resource("item/essence_tall_gem");
    public static final ResourceLocation ESSENCE_DIAMOND_BLANK = MysticalAgricultureAPI.resource("item/essence_diamond");
    public static final ResourceLocation ESSENCE_QUARTZ_BLANK = MysticalAgricultureAPI.resource("item/essence_quartz");
    public static final ResourceLocation ESSENCE_FLAME_BLANK = MysticalAgricultureAPI.resource("item/essence_flame");
    public static final ResourceLocation ESSENCE_ROD_BLANK = MysticalAgricultureAPI.resource("item/essence_rod");
    public static final ResourceLocation SEED_BLANK = MysticalAgricultureAPI.resource("item/mystical_seeds");
    public static final CropTextures INGOT_CROP_TEXTURES = new CropTextures(FLOWER_INGOT_BLANK, ESSENCE_INGOT_BLANK);
    public static final CropTextures ROCK_CROP_TEXTURES = new CropTextures(FLOWER_ROCK_BLANK, ESSENCE_ROCK_BLANK);
    public static final CropTextures DUST_CROP_TEXTURES = new CropTextures(FLOWER_DUST_BLANK, ESSENCE_DUST_BLANK);
    public static final CropTextures GEM_CROP_TEXTURES = new CropTextures(FLOWER_ROCK_BLANK, ESSENCE_GEM_BLANK);
    public static final CropTextures ELEMENTAL_CROP_TEXTURES = new CropTextures(FLOWER_INGOT_BLANK, ESSENCE_FLAME_BLANK);
    private ResourceLocation flowerTexture;
    private ResourceLocation essenceTexture;
    private ResourceLocation seedTexture;

    public CropTextures() {
        this(null, null, null);
    }

    public CropTextures(ResourceLocation flowerTexture, ResourceLocation essenceTexture) {
        this(flowerTexture, essenceTexture, SEED_BLANK);
    }

    public CropTextures(ResourceLocation flowerTexture, ResourceLocation essenceTexture, ResourceLocation seedTexture) {
        this.flowerTexture = flowerTexture;
        this.essenceTexture = essenceTexture;
        this.seedTexture = seedTexture;
    }

    public ResourceLocation getFlowerTexture() {
        return this.flowerTexture;
    }

    public CropTextures setFlowerTexture(ResourceLocation location) {
        this.flowerTexture = location;
        return this;
    }

    public ResourceLocation getEssenceTexture() {
        return this.essenceTexture;
    }

    public CropTextures setEssenceTexture(ResourceLocation location) {
        this.essenceTexture = location;
        return this;
    }

    public ResourceLocation getSeedTexture() {
        return this.seedTexture;
    }

    public CropTextures setSeedTexture(ResourceLocation location) {
        this.seedTexture = location;
        return this;
    }

    public CropTextures init(ResourceLocation id) {
        String modid = id.getNamespace();
        String name = id.getPath();
        if (this.flowerTexture == null) {
            this.flowerTexture = ResourceLocation.fromNamespaceAndPath((String)modid, (String)("block/flower/" + name + "_flower"));
        }
        if (this.essenceTexture == null) {
            this.essenceTexture = ResourceLocation.fromNamespaceAndPath((String)modid, (String)("item/essence/" + name + "_essence"));
        }
        if (this.seedTexture == null) {
            this.seedTexture = ResourceLocation.fromNamespaceAndPath((String)modid, (String)("item/seeds/" + name + "_seeds"));
        }
        return this;
    }
}

