/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.objects;

import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.event.AnvilUpdateEvent;

public class ImprovedScrappingTomeItem
extends BookItem {
    static Random rand = new Random();

    public ImprovedScrappingTomeItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (stack.isEnchanted()) {
            return;
        }
        tooltip.add((Component)TooltipUtil.lang("info", "improved_scrap_tome", new Object[0]).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)TooltipUtil.lang("info", "improved_scrap_tome2", new Object[0]).withStyle(ChatFormatting.GRAY));
    }

    public static boolean updateAnvil(AnvilUpdateEvent ev) {
        ItemStack weapon = ev.getLeft();
        ItemStack book = ev.getRight();
        if (!(book.getItem() instanceof ImprovedScrappingTomeItem) || book.isEnchanted() || !weapon.isEnchanted()) {
            return false;
        }
        ItemEnchantments wepEnch = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)weapon);
        ItemStack out = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        EnchantmentHelper.setEnchantments((ItemStack)out, (ItemEnchantments)wepEnch);
        ev.setMaterialCost(1);
        ev.setCost((long)(wepEnch.size() * 10));
        ev.setOutput(out);
        return true;
    }
}

