/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.mixin;

import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class}, priority=500, remap=false)
public class ItemStackMixin {
    @Inject(method={"addToTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    public <T extends TooltipProvider> void apoth_enchTooltipRewrite(DataComponentType<T> component, Item.TooltipContext ctx, Consumer<Component> tooltip, TooltipFlag tooltipFlag, CallbackInfo ci) {
        ItemStack ths = (ItemStack)this;
        TooltipProvider t = (TooltipProvider)ths.get(component);
        if (component == DataComponents.ENCHANTMENTS && t instanceof ItemEnchantments) {
            ItemEnchantments enchants = (ItemEnchantments)t;
            HolderLookup.Provider regs = ctx.registries();
            if (regs == null || !enchants.showInTooltip) {
                return;
            }
            HolderSet iterationOrder = ItemStackMixin.getTagOrEmpty(regs, Registries.ENCHANTMENT, EnchantmentTags.TOOLTIP_ORDER);
            ItemEnchantments realLevels = ths.getAllEnchantments(regs.lookupOrThrow(Registries.ENCHANTMENT));
            Consumer<Holder> applyTooltip = ench -> TooltipUtil.applyEnchTooltip((Holder<Enchantment>)ench, enchants, realLevels, tooltip);
            iterationOrder.forEach(applyTooltip);
            HashSet seen = new HashSet();
            enchants.entrySet().stream().map(Map.Entry::getKey).filter(ench -> !iterationOrder.contains(ench)).forEach(ench -> {
                applyTooltip.accept((Holder)ench);
                seen.add(ench);
            });
            realLevels.entrySet().stream().map(Map.Entry::getKey).filter(ench -> !iterationOrder.contains(ench)).filter(ench -> !seen.contains(ench)).forEach(applyTooltip);
            ci.cancel();
        }
    }

    @Unique
    private static <T> HolderSet<T> getTagOrEmpty(@Nullable HolderLookup.Provider registries, ResourceKey<Registry<T>> registryKey, TagKey<T> key) {
        Optional optional;
        if (registries != null && (optional = registries.lookupOrThrow(registryKey).get(key)).isPresent()) {
            return (HolderSet)optional.get();
        }
        return HolderSet.direct((Holder[])new Holder[0]);
    }
}

