/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.network;

import mcjty.rftoolsutility.modules.logic.blocks.RedstoneTransmitterTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketSetChannelName(BlockPos pos, String name) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"setchannelname");
    public static final CustomPacketPayload.Type<PacketSetChannelName> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, PacketSetChannelName> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketSetChannelName::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, PacketSetChannelName::name, PacketSetChannelName::new);

    public static PacketSetChannelName create(BlockPos worldPosition, String channelName) {
        return new PacketSetChannelName(worldPosition, channelName);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity te;
            Player player = ctx.player();
            Level world = player.getCommandSenderWorld();
            if (world.hasChunkAt(this.pos) && (te = world.getBlockEntity(this.pos)) instanceof RedstoneTransmitterTileEntity) {
                RedstoneTransmitterTileEntity transmitter = (RedstoneTransmitterTileEntity)te;
                transmitter.setChannelName(this.name);
            }
        });
    }
}

