/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world.summoning;

import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.world.summoning.StoredBoundHorse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SummoningStorage
extends SavedData {
    protected final Map<UUID, Map<ResourceKey<Instrument>, StoredBoundHorse>> boundHorses;
    protected final List<UUID> unboundHorses;
    protected final List<UUID> horsesToRemove;

    private SummoningStorage(Map<UUID, Map<ResourceKey<Instrument>, StoredBoundHorse>> boundHorses, List<UUID> unboundHorses, List<UUID> horsesToRemove) {
        this.boundHorses = boundHorses;
        this.unboundHorses = unboundHorses;
        this.horsesToRemove = horsesToRemove;
    }

    private SummoningStorage() {
        this(new HashMap<UUID, Map<ResourceKey<Instrument>, StoredBoundHorse>>(), new ArrayList<UUID>(), new ArrayList<UUID>());
    }

    public Map<UUID, Map<ResourceKey<Instrument>, StoredBoundHorse>> getBoundHorses() {
        return this.boundHorses;
    }

    public List<UUID> getUnboundHorses() {
        return this.unboundHorses;
    }

    public List<UUID> getHorsesToRemove() {
        return this.horsesToRemove;
    }

    @NotNull
    public static SummoningStorage loadOrCreate(MinecraftServer server) {
        return (SummoningStorage)server.overworld().getDataStorage().computeIfAbsent(SummoningStorage.factory(), "horseman_horse_calling");
    }

    private static SavedData.Factory<SummoningStorage> factory() {
        return new SavedData.Factory(SummoningStorage::new, SummoningStorage::load, null);
    }

    private static SummoningStorage load(CompoundTag tag, HolderLookup.Provider provider) {
        try {
            CompoundTag boundHorsesTag = tag.getCompound("BoundHorses");
            HashMap<UUID, Map<ResourceKey<Instrument>, StoredBoundHorse>> boundHorses = new HashMap<UUID, Map<ResourceKey<Instrument>, StoredBoundHorse>>();
            for (String uuidStr : boundHorsesTag.getAllKeys()) {
                UUID uuid = UUID.fromString(uuidStr);
                CompoundTag innerTag = boundHorsesTag.getCompound(uuidStr);
                HashMap<ResourceKey, StoredBoundHorse> innerMap = new HashMap<ResourceKey, StoredBoundHorse>();
                for (String instrumentString : innerTag.getAllKeys()) {
                    ResourceLocation location = ResourceLocation.parse((String)instrumentString);
                    ResourceKey instrumentKey = ResourceKey.create((ResourceKey)Registries.INSTRUMENT, (ResourceLocation)location);
                    CompoundTag horseTag = innerTag.getCompound(instrumentString);
                    @Nullable StoredBoundHorse horse = StoredBoundHorse.load(horseTag);
                    if (horse == null) continue;
                    innerMap.put(instrumentKey, horse);
                }
                boundHorses.put(uuid, innerMap);
            }
            ArrayList<UUID> unboundHorses = new ArrayList<UUID>();
            ListTag unboundHorsesListTag = tag.getList("UnboundHorses", 11);
            for (Tag unboundUUID : unboundHorsesListTag) {
                unboundHorses.add(NbtUtils.loadUUID((Tag)unboundUUID));
            }
            ArrayList<UUID> horsesToRemove = new ArrayList<UUID>();
            ListTag horsesToRemoveListTag = tag.getList("HorsesToRemove", 11);
            for (Tag toRemoveUUID : horsesToRemoveListTag) {
                horsesToRemove.add(NbtUtils.loadUUID((Tag)toRemoveUUID));
            }
            return new SummoningStorage(boundHorses, unboundHorses, horsesToRemove);
        }
        catch (Exception e) {
            Horseman.LOGGER.error("Failed to load HorseCallingStorage: ", (Throwable)e);
            return new SummoningStorage();
        }
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag boundHorsesTag = new CompoundTag();
        for (Map.Entry<UUID, Map<ResourceKey<Instrument>, StoredBoundHorse>> entry : this.boundHorses.entrySet()) {
            UUID uuid = entry.getKey();
            Map<ResourceKey<Instrument>, StoredBoundHorse> innerMap = entry.getValue();
            CompoundTag innerTag = new CompoundTag();
            for (Map.Entry<ResourceKey<Instrument>, StoredBoundHorse> innerEntry : innerMap.entrySet()) {
                ResourceKey<Instrument> key = innerEntry.getKey();
                StoredBoundHorse horse = innerEntry.getValue();
                CompoundTag horseTag = horse.save(new CompoundTag());
                innerTag.put(key.location().toString(), (Tag)horseTag);
            }
            boundHorsesTag.put(uuid.toString(), (Tag)innerTag);
        }
        tag.put("BoundHorses", (Tag)boundHorsesTag);
        ListTag unboundHorsesListTag = new ListTag();
        for (UUID uuid : this.unboundHorses) {
            unboundHorsesListTag.add((Object)NbtUtils.createUUID((UUID)uuid));
        }
        tag.put("UnboundHorses", (Tag)unboundHorsesListTag);
        ListTag listTag = new ListTag();
        for (UUID uuid : this.horsesToRemove) {
            listTag.add((Object)NbtUtils.createUUID((UUID)uuid));
        }
        tag.put("HorsesToRemove", (Tag)listTag);
        return tag;
    }
}

