/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.world.summoning;

import io.github.mortuusars.horseman.Horseman;
import io.github.mortuusars.horseman.world.summoning.BoundData;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StoredBoundHorse {
    @Nullable
    protected final BoundData boundData;
    protected final CompoundTag tag;
    protected final UUID entityUuid;
    protected final Vec3 position;
    protected final ResourceKey<Level> dimension;
    protected final boolean isDead;

    public StoredBoundHorse(@Nullable BoundData boundData, CompoundTag tag, UUID entityUuid, Vec3 position, ResourceKey<Level> dimension, boolean isDead) {
        this.boundData = boundData;
        this.tag = tag;
        this.entityUuid = entityUuid;
        this.position = position;
        this.dimension = dimension;
        this.isDead = isDead;
    }

    public StoredBoundHorse(AbstractHorse horse) {
        this(horse.getHorsemanBoundData(), StoredBoundHorse.saveToTag(horse), horse.getUUID(), horse.position(), (ResourceKey<Level>)horse.level().dimension(), horse.isDeadOrDying());
    }

    public static CompoundTag saveToTag(AbstractHorse horse) {
        CompoundTag tag = new CompoundTag();
        tag.putString("id", EntityType.getKey((EntityType)horse.getType()).toString());
        horse.saveWithoutId(tag);
        return tag;
    }

    @Nullable
    public BoundData getBoundData() {
        return this.boundData;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public UUID getEntityUuid() {
        return this.entityUuid;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public boolean isInSameDimension(Player player) {
        return this.isInSameDimension((ResourceKey<Level>)player.level().dimension());
    }

    public boolean isInSameDimension(ResourceKey<Level> dimension) {
        return this.getDimension().equals(dimension);
    }

    public CompoundTag save(CompoundTag tag) {
        if (this.boundData != null) {
            tag.put("BoundData", (Tag)this.boundData.save(new CompoundTag()));
        }
        tag.put("Tag", (Tag)this.tag);
        tag.putUUID("EntityUUID", this.entityUuid);
        tag.putDouble("PosX", this.position.x);
        tag.putDouble("PosY", this.position.y);
        tag.putDouble("PosZ", this.position.z);
        tag.putString("Dimension", this.dimension.location().toString());
        tag.putBoolean("IsDead", this.isDead);
        return tag;
    }

    @Nullable
    public static StoredBoundHorse load(CompoundTag tag) {
        try {
            @Nullable BoundData boundData = BoundData.load(tag.getCompound("BoundData"));
            CompoundTag storedTag = tag.getCompound("Tag");
            UUID entityUUID = tag.getUUID("EntityUUID");
            Vec3 position = new Vec3(tag.getDouble("PosX"), tag.getDouble("PosY"), tag.getDouble("PosZ"));
            ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString("Dimension")));
            boolean isDead = tag.getBoolean("IsDead");
            return new StoredBoundHorse(boundData, storedTag, entityUUID, position, (ResourceKey<Level>)dimension, isDead);
        }
        catch (Exception e) {
            Horseman.LOGGER.error("Failed to load StoredBoundHorse: ", (Throwable)e);
            return null;
        }
    }
}

