/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.network;

import com.google.common.base.Preconditions;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.mortuusars.horseman.network.neoforge.PacketsImpl;
import io.github.mortuusars.horseman.network.packet.Packet;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class Packets {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToServer(Packet packet) {
        PacketsImpl.sendToServer(packet);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToClient(Packet packet, ServerPlayer player) {
        void var1_1;
        PacketsImpl.sendToClient(packet, (ServerPlayer)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToAllClients(Packet packet) {
        PacketsImpl.sendToAllClients(packet);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void sendToPlayersTrackingEntity(Entity entity, Packet packet) {
        void var1_1;
        PacketsImpl.sendToPlayersTrackingEntity(entity, (Packet)var1_1);
    }

    public static void sendToClients(Packet packet, PlayerList playerList, @Nullable ServerPlayer excludedPlayer) {
        for (ServerPlayer player : playerList.getPlayers()) {
            if (player == excludedPlayer) continue;
            Packets.sendToClient(packet, player);
        }
    }

    public static void sendToClients(Packet packet, ServerPlayer origin, Predicate<ServerPlayer> filter) {
        Preconditions.checkState((origin.getServer() != null ? 1 : 0) != 0, (Object)"Server cannot be null");
        for (ServerPlayer player : origin.getServer().getPlayerList().getPlayers()) {
            if (!filter.test(player)) continue;
            Packets.sendToClient(packet, player);
        }
    }

    public static void sendToOtherClients(Packet packet, ServerPlayer excludedPlayer) {
        Packets.sendToClients(packet, excludedPlayer, (ServerPlayer serverPlayer) -> !serverPlayer.equals((Object)excludedPlayer));
    }

    public static void sendToOtherClients(Packet packet, ServerPlayer excludedPlayer, Predicate<ServerPlayer> filter) {
        Packets.sendToClients(packet, excludedPlayer, (ServerPlayer serverPlayer) -> !serverPlayer.equals((Object)excludedPlayer) && filter.test((ServerPlayer)serverPlayer));
    }
}

