/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.neoforge.mixin.mount_gui;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.mortuusars.horseman.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public abstract class GuiMixin {
    @Unique
    private long horseman$lastTickVehicleInWater = -1L;

    @WrapOperation(method={"renderFoodLevel(Lnet/minecraft/client/gui/GuiGraphics;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;getVehicleMaxHearts(Lnet/minecraft/world/entity/LivingEntity;)I")})
    private int renderFoodLevel_getVehicleMaxHearts(Gui instance, LivingEntity vehicle, Operation<Integer> original) {
        if (!((Boolean)Config.Client.IMPROVED_MOUNT_GUI.get()).booleanValue()) {
            return (Integer)original.call(new Object[]{instance, vehicle});
        }
        return 0;
    }

    @Inject(method={"renderJumpMeter(Lnet/minecraft/world/entity/PlayerRideableJumping;Lnet/minecraft/client/gui/GuiGraphics;I)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderJumpMeter(PlayerRideableJumping rideable, GuiGraphics guiGraphics, int x, CallbackInfo ci) {
        LivingEntity entity;
        if (!((Boolean)Config.Client.IMPROVED_MOUNT_GUI.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.gameMode == null || !mc.gameMode.hasExperience() || mc.player == null || mc.level == null) {
            return;
        }
        if (rideable instanceof LivingEntity && (entity = (LivingEntity)rideable).isInWater()) {
            this.horseman$lastTickVehicleInWater = mc.player.level().getGameTime();
        }
        if (!mc.options.keyJump.isDown() && mc.player.getJumpRidingScale() <= 0.0f || mc.level.getGameTime() - this.horseman$lastTickVehicleInWater < 10L) {
            ci.cancel();
        }
    }

    @ModifyReturnValue(method={"isExperienceBarVisible()Z"}, at={@At(value="RETURN")})
    private boolean isExperienceBarVisible(boolean original) {
        if (!((Boolean)Config.Client.IMPROVED_MOUNT_GUI.get()).booleanValue()) {
            return original;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.gameMode == null || !mc.gameMode.hasExperience() || mc.level == null || mc.player == null) {
            return original;
        }
        if (!mc.options.keyJump.isDown() && mc.player.getJumpRidingScale() <= 0.0f || mc.level.getGameTime() - this.horseman$lastTickVehicleInWater < 10L) {
            return true;
        }
        return original;
    }

    @WrapOperation(method={"maybeRenderExperienceBar(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;jumpableVehicle()Lnet/minecraft/world/entity/PlayerRideableJumping;")})
    private PlayerRideableJumping renderHotbarAndDecorations_jumpableVehicle(LocalPlayer instance, Operation<PlayerRideableJumping> original) {
        @Nullable PlayerRideableJumping vehicle = (PlayerRideableJumping)original.call(new Object[]{instance});
        if (vehicle == null || !((Boolean)Config.Client.IMPROVED_MOUNT_GUI.get()).booleanValue()) {
            return vehicle;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.gameMode == null || !mc.gameMode.hasExperience() || mc.level == null || mc.player == null) {
            return vehicle;
        }
        if (!mc.options.keyJump.isDown() && mc.player.getJumpRidingScale() <= 0.0f || mc.level.getGameTime() - this.horseman$lastTickVehicleInWater < 10L) {
            return null;
        }
        return vehicle;
    }

    @WrapOperation(method={"renderExperienceLevel(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/Gui;isExperienceBarVisible()Z")})
    private boolean renderExperienceLevel_isExperienceBarVisible(Gui instance, Operation<Boolean> original) {
        if (!((Boolean)Config.Client.IMPROVED_MOUNT_GUI.get()).booleanValue()) {
            return (Boolean)original.call(new Object[]{instance});
        }
        return Minecraft.getInstance().gameMode != null && Minecraft.getInstance().gameMode.hasExperience();
    }
}

