/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.tame_with_item;

import io.github.mortuusars.horseman.Config;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Horse.class})
public class HorseMixin
extends AbstractHorse {
    protected HorseMixin(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onMobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (!((Boolean)Config.Server.HORSE_ALLOW_TAMING_WITH_ITEM_IN_HAND.get()).booleanValue()) {
            return;
        }
        if (player.isSecondaryUseActive() || this.isVehicle() || this.isBaby() || this.isTamed() || this.isFood(player.getItemInHand(hand))) {
            return;
        }
        if (!player.getItemInHand(hand).isEmpty()) {
            this.doPlayerRide(player);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }
}

