/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.switch_inventory;

import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.client.SwitchInventory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={InventoryScreen.class})
public abstract class InventoryScreenMixin
extends EffectRenderingInventoryScreen<InventoryMenu> {
    @Unique
    @Nullable
    private ImageButton horseman$playerInventorySwitchButton;

    public InventoryScreenMixin(InventoryMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    @Inject(method={"init()V"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        if (!SwitchInventory.isEnabled() || Minecraft.getInstance().gameMode == null || !Minecraft.getInstance().gameMode.isServerControlledInventory()) {
            return;
        }
        InventoryScreenMixin inventoryScreenMixin = this;
        if (inventoryScreenMixin instanceof InventoryScreen) {
            MutableComponent mutableComponent;
            Entity entity;
            InventoryScreen inventoryScreen = (InventoryScreen)inventoryScreenMixin;
            this.horseman$playerInventorySwitchButton = new ImageButton(this.leftPos + (Integer)Config.Client.INVENTORY_SWITCH_PLAYER_BUTTON_X.get(), this.topPos + (Integer)Config.Client.INVENTORY_SWITCH_PLAYER_BUTTON_Y.get(), 14, 15, SwitchInventory.SWITCH_BUTTON_RIGHT_SPRITES, b -> SwitchInventory.switchToMount((Screen)inventoryScreen));
            if (Minecraft.getInstance().player != null && (entity = Minecraft.getInstance().player.getVehicle()) instanceof Entity) {
                Entity entity2 = entity;
                mutableComponent = entity2.getName();
            } else {
                mutableComponent = Component.translatable((String)"gui.horseman.switch_inventory.button.to_mount.tooltip.mount");
            }
            MutableComponent vehicleName = mutableComponent;
            this.horseman$playerInventorySwitchButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.horseman.switch_inventory.button.to_mount.tooltip", (Object[])new Object[]{vehicleName, Component.literal((String)Minecraft.getInstance().options.keyInventory.getTranslatedKeyMessage().getString()).withStyle(ChatFormatting.GRAY)})));
            this.addRenderableWidget((GuiEventListener)this.horseman$playerInventorySwitchButton);
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    private void onRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        if (this.horseman$playerInventorySwitchButton != null) {
            this.horseman$playerInventorySwitchButton.setX(this.leftPos + (Integer)Config.Client.INVENTORY_SWITCH_PLAYER_BUTTON_X.get());
        }
    }

    @Inject(method={"keyPressed(III)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!SwitchInventory.isEnabled() || Minecraft.getInstance().gameMode == null || !Minecraft.getInstance().gameMode.isServerControlledInventory()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (this instanceof InventoryScreen && minecraft.options.keyInventory.matches(keyCode, scanCode) && Screen.hasControlDown()) {
            SwitchInventory.switchToMount((Screen)this);
            minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            cir.setReturnValue((Object)true);
        }
    }
}

