/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.switch_inventory;

import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.client.SwitchInventory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.HorseInventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin
extends Screen {
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;

    protected AbstractContainerScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init()V"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        if (!SwitchInventory.isEnabled()) {
            return;
        }
        if (Minecraft.getInstance().gameMode == null) {
            return;
        }
        if (this instanceof HorseInventoryScreen) {
            SwitchInventory.restoreMousePosIfNeeded();
            ImageButton switchButton = new ImageButton(this.leftPos + (Integer)Config.Client.INVENTORY_SWITCH_HORSE_BUTTON_X.get(), this.topPos + (Integer)Config.Client.INVENTORY_SWITCH_HORSE_BUTTON_Y.get(), 14, 15, SwitchInventory.SWITCH_BUTTON_LEFT_SPRITES, b -> SwitchInventory.switchToInventory((AbstractContainerScreen)this));
            switchButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.horseman.switch_inventory.button.to_inventory.tooltip", (Object[])new Object[]{Component.literal((String)Minecraft.getInstance().options.keyInventory.getTranslatedKeyMessage().getString()).withStyle(ChatFormatting.GRAY)})));
            this.addRenderableWidget((GuiEventListener)switchButton);
        }
    }

    @Inject(method={"keyPressed(III)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!SwitchInventory.isEnabled()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if ((AbstractContainerScreen)this instanceof HorseInventoryScreen && minecraft.options.keyInventory.matches(keyCode, scanCode) && Screen.hasControlDown()) {
            SwitchInventory.switchToInventory((AbstractContainerScreen)this);
            minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            cir.setReturnValue((Object)true);
        }
    }
}

