/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.render;

import com.llamalad7.mixinextras.sugar.Local;
import io.github.mortuusars.horseman.client.HorseRenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.DyeColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntityRenderer.class}, priority=950)
public abstract class LivingEntityRendererMixin<T extends LivingEntity>
extends EntityRenderer<T> {
    protected LivingEntityRendererMixin(EntityRendererProvider.Context context) {
        super(context);
    }

    @ModifyArg(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;III)V"), index=4)
    int setOpacityAndChromaForRender(int color, @Local(argsOnly=true) LivingEntity entity) {
        if (entity instanceof AbstractHorse) {
            if (HorseRenderUtils.isJeb(entity)) {
                int index = entity.tickCount / 25 + entity.getId();
                int dyesCount = DyeColor.values().length;
                int currentIndex = index % dyesCount;
                int nextIndex = (index + 1) % dyesCount;
                float transition = ((float)(entity.tickCount % 25) + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true)) / 25.0f;
                int currentColor = Sheep.getColor((DyeColor)DyeColor.byId((int)currentIndex));
                int nextColor = Sheep.getColor((DyeColor)DyeColor.byId((int)nextIndex));
                color = FastColor.ARGB32.lerp((float)transition, (int)currentColor, (int)nextColor);
                color = FastColor.ARGB32.color((int)Math.min(FastColor.ARGB32.red((int)color) * 2, 255), (int)Math.min(FastColor.ARGB32.green((int)color) * 2, 255), (int)Math.min(FastColor.ARGB32.blue((int)color) * 2, 255));
            }
            int a = FastColor.ARGB32.alpha((int)color);
            a = Mth.clamp((int)((int)((float)a * HorseRenderUtils.getAlpha(entity))), (int)0, (int)255);
            return FastColor.ARGB32.color((int)a, (int)color);
        }
        return color;
    }

    @Inject(method={"getRenderType(Lnet/minecraft/world/entity/LivingEntity;ZZZ)Lnet/minecraft/client/renderer/RenderType;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getRenderType(T entity, boolean bodyVisible, boolean translucent, boolean glowing, CallbackInfoReturnable<RenderType> cir) {
        if (entity instanceof AbstractHorse && HorseRenderUtils.getAlpha(entity) < 1.0f) {
            cir.setReturnValue((Object)RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation((Entity)entity)));
        }
    }
}

