/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.render;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import io.github.mortuusars.horseman.client.HorseRenderUtils;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.HorseArmorLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Horse;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(value={HorseArmorLayer.class}, priority=950)
public abstract class HorseArmorLayerMixin {
    @WrapOperation(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/animal/horse/Horse;FFFFFF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;entityCutoutNoCull(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/RenderType;")})
    RenderType makeRenderLayerTranslucent(ResourceLocation location, Operation<RenderType> original, @Local(argsOnly=true) Horse horse, @Share(value="alpha") LocalFloatRef alpha) {
        float a = HorseRenderUtils.getAlpha((LivingEntity)horse);
        alpha.set(a);
        if ((double)a < 1.0) {
            return RenderType.entityTranslucent((ResourceLocation)location);
        }
        return (RenderType)original.call(new Object[]{location});
    }

    @ModifyArg(method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/entity/animal/horse/Horse;FFFFFF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/HorseModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;III)V"), index=4)
    int setOpacityForRender(int color, @Share(value="alpha") LocalFloatRef alpha) {
        int a = FastColor.ARGB32.alpha((int)color);
        a = Mth.clamp((int)((int)((float)a * alpha.get())), (int)0, (int)255);
        return FastColor.ARGB32.color((int)a, (int)color);
    }
}

