/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.hitching;

import io.github.mortuusars.horseman.world.HitchableHorse;
import io.github.mortuusars.horseman.world.menu.LeadSlot;
import net.minecraft.world.Container;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HorseInventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HorseInventoryMenu.class})
public abstract class HorseInventoryMenuMixin
extends AbstractContainerMenu {
    @Shadow
    @Final
    private Container horseContainer;
    @Shadow
    @Final
    private AbstractHorse horse;

    protected HorseInventoryMenuMixin(@Nullable MenuType<?> menuType, int containerId) {
        super(menuType, containerId);
    }

    @Inject(method={"<init>(ILnet/minecraft/world/entity/player/Inventory;Lnet/minecraft/world/Container;Lnet/minecraft/world/entity/animal/horse/AbstractHorse;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/inventory/HorseInventoryMenu;addSlot(Lnet/minecraft/world/inventory/Slot;)Lnet/minecraft/world/inventory/Slot;", ordinal=1, shift=At.Shift.AFTER)})
    private void onInit(int containerId, Inventory inventory, Container horseContainer, final AbstractHorse horse, int columns, CallbackInfo ci) {
        if (!(horse instanceof HitchableHorse)) {
            return;
        }
        final HitchableHorse hitchableHorse = (HitchableHorse)horse;
        if (!HitchableHorse.shouldHaveLeadSlot(hitchableHorse)) {
            return;
        }
        this.addSlot(new LeadSlot(this, hitchableHorse.horseman$getLeadAccess(), 0, 8, 54){

            public boolean mayPlace(ItemStack stack) {
                return HitchableHorse.mayPlaceInLeadSlot(hitchableHorse, stack);
            }

            public boolean mayPickup(Player player) {
                ItemStack stack = this.getItem();
                return !stack.is(Items.LEAD) || !HitchableHorse.isHitched(hitchableHorse);
            }

            public boolean isActive() {
                return horse.level().isClientSide || HitchableHorse.isLeadSlotActive(hitchableHorse);
            }
        });
    }

    @Inject(method={"quickMoveStack(Lnet/minecraft/world/entity/player/Player;I)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onQuickMoveStack(Player player, int index, CallbackInfoReturnable<ItemStack> cir) {
        AbstractHorse abstractHorse = this.horse;
        if (!(abstractHorse instanceof HitchableHorse)) {
            return;
        }
        HitchableHorse hitchableHorse = (HitchableHorse)abstractHorse;
        if (!HitchableHorse.shouldHaveLeadSlot(hitchableHorse)) {
            return;
        }
        if (index < this.horseContainer.getContainerSize() + 1) {
            return;
        }
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return;
        }
        ItemStack clickedStack = slot.getItem();
        if (!clickedStack.is(Items.LEAD)) {
            return;
        }
        ItemStack clickedStackCopy = clickedStack.copy();
        Slot leadSlot = this.getSlot(2);
        if (!leadSlot.mayPlace(clickedStack)) {
            return;
        }
        ItemStack movedStack = clickedStack.copyWithCount(1);
        if (!leadSlot.getItem().isEmpty()) {
            if (!this.moveItemStackTo(clickedStack, 3, this.horseContainer.getContainerSize(), false)) {
                cir.setReturnValue((Object)ItemStack.EMPTY);
                return;
            }
            if (clickedStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (clickedStack.getCount() == clickedStackCopy.getCount()) {
                cir.setReturnValue((Object)ItemStack.EMPTY);
                return;
            }
            slot.onTake(player, clickedStack);
            cir.setReturnValue((Object)ItemStack.EMPTY);
            return;
        }
        clickedStack.shrink(1);
        ((Slot)this.slots.get(2)).setByPlayer(movedStack);
        if (clickedStack.isEmpty()) {
            slot.setByPlayer(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (clickedStack.getCount() == clickedStackCopy.getCount()) {
            cir.setReturnValue((Object)ItemStack.EMPTY);
            return;
        }
        slot.onTake(player, clickedStack);
        cir.setReturnValue((Object)ItemStack.EMPTY);
    }
}

