/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.dismount;

import io.github.mortuusars.horseman.Config;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixin
extends Animal {
    @Shadow
    @Nullable
    protected abstract Vec3 getDismountLocationInDirection(Vec3 var1, LivingEntity var2);

    protected AbstractHorseMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"getDismountLocationForPassenger(Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getDismountLocation(LivingEntity passenger, CallbackInfoReturnable<Vec3> cir) {
        Vec3 escapeVector;
        Vec3 location;
        if (((Boolean)Config.Server.DISMOUNT_TOWARDS_VIEW_DIRECTION.get()).booleanValue() && (location = this.getDismountLocationInDirection(escapeVector = AbstractHorseMixin.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)passenger.getBbWidth(), (float)passenger.getYRot()), passenger)) != null) {
            cir.setReturnValue((Object)location);
        }
    }
}

