/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.client;

import io.github.mortuusars.horseman.Config;
import io.github.mortuusars.horseman.Horseman;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class SwitchInventory {
    public static final WidgetSprites SWITCH_BUTTON_LEFT_SPRITES = new WidgetSprites(Horseman.resource("switch_inventory_button_left"), Horseman.resource("switch_inventory_button_left_disabled"), Horseman.resource("switch_inventory_button_left_highlighted"));
    public static final WidgetSprites SWITCH_BUTTON_RIGHT_SPRITES = new WidgetSprites(Horseman.resource("switch_inventory_button_right"), Horseman.resource("switch_inventory_button_right_disabled"), Horseman.resource("switch_inventory_button_right_highlighted"));
    @Nullable
    public static Double mouseX;
    @Nullable
    public static Double mouseY;

    public static boolean isEnabled() {
        return (Boolean)Config.Client.INVENTORY_SWITCH_ENABLED.get();
    }

    public static void switchToInventory(AbstractContainerScreen<?> screen) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        double cursorX = Minecraft.getInstance().mouseHandler.xpos();
        double cursorY = Minecraft.getInstance().mouseHandler.ypos();
        screen.onClose();
        Minecraft.getInstance().setScreen((Screen)new InventoryScreen((Player)Minecraft.getInstance().player));
        Minecraft.getInstance().execute(() -> GLFW.glfwSetCursorPos((long)Minecraft.getInstance().getWindow().getWindow(), (double)cursorX, (double)cursorY));
    }

    public static void switchToMount(Screen screen) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        mouseX = Minecraft.getInstance().mouseHandler.xpos();
        mouseY = Minecraft.getInstance().mouseHandler.ypos();
        screen.onClose();
        Minecraft.getInstance().player.sendOpenInventory();
    }

    public static void restoreMousePosIfNeeded() {
        if (mouseX != null && mouseY != null) {
            GLFW.glfwSetCursorPos((long)Minecraft.getInstance().getWindow().getWindow(), (double)mouseX, (double)mouseY);
            mouseX = null;
            mouseY = null;
        }
    }
}

