/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.client;

import io.github.mortuusars.horseman.Config;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class HorseStatsTooltip {
    public static void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Horse horse;
        Minecraft minecraft;
        block7: {
            block6: {
                EntityHitResult entityHitResult;
                HitResult hitResult;
                if (!((Boolean)Config.Common.HORSE_STATS_TOOLTIP.get()).booleanValue()) {
                    return;
                }
                minecraft = Minecraft.getInstance();
                if (minecraft.options.hideGui || minecraft.level == null || minecraft.player == null || minecraft.player.isSpectator() || minecraft.screen != null || !((hitResult = minecraft.hitResult) instanceof EntityHitResult) || !((hitResult = (entityHitResult = (EntityHitResult)hitResult).getEntity()) instanceof Horse)) break block6;
                horse = (Horse)hitResult;
                if (minecraft.player.getMainHandItem().is(ItemTags.HORSE_FOOD) || minecraft.player.getOffhandItem().is(ItemTags.HORSE_FOOD)) break block7;
            }
            return;
        }
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(2);
        ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
        lines.add(Component.translatable((String)"gui.horseman.horse_stats_tooltip.stats").getVisualOrderText());
        float health = horse.getMaxHealth();
        lines.add(Component.translatable((String)"gui.horseman.horse_stats_tooltip.health", (Object[])new Object[]{numberFormat.format(health)}).getVisualOrderText());
        if (horse.getAttributes().hasAttribute(Attributes.JUMP_STRENGTH)) {
            double jumpHeight = HorseStatsTooltip.getJumpHeight(horse.getAttributeBaseValue(Attributes.JUMP_STRENGTH));
            lines.add(Component.translatable((String)"gui.horseman.horse_stats_tooltip.jump_height", (Object[])new Object[]{numberFormat.format(jumpHeight)}).getVisualOrderText());
        }
        if (horse.getAttributes().hasAttribute(Attributes.MOVEMENT_SPEED)) {
            double blocksPerSecond = horse.getAttributeBaseValue(Attributes.MOVEMENT_SPEED) * 42.16;
            lines.add(Component.translatable((String)"gui.horseman.horse_stats_tooltip.speed", (Object[])new Object[]{numberFormat.format(blocksPerSecond)}).getVisualOrderText());
        }
        int x = minecraft.getWindow().getGuiScaledWidth() / 2 + 8;
        int y = minecraft.getWindow().getGuiScaledHeight() / 2 - (int)((float)lines.size() / 2.0f * 9.0f);
        guiGraphics.renderTooltip(minecraft.font, lines, x, y + 10);
    }

    private static double getJumpHeight(double jumpStrength) {
        return -0.1817584952 * jumpStrength * jumpStrength * jumpStrength + 3.689713992 * jumpStrength * jumpStrength + 2.128599134 * jumpStrength - 0.343930367;
    }
}

