/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.items;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class Drink
extends Item {
    public Drink(Item.Properties settings) {
        super(settings);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getEatingSound() {
        return this.getDrinkingSound();
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        Player playerEntity;
        Player player = playerEntity = user instanceof Player ? (Player)user : null;
        if (playerEntity instanceof ServerPlayer) {
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)playerEntity, stack);
        }
        if (playerEntity != null) {
            playerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!playerEntity.getAbilities().instabuild && stack.has(DataComponents.FOOD)) {
                user.eat(world, stack);
            }
        }
        if (playerEntity == null || !playerEntity.getAbilities().instabuild) {
            if (stack.isEmpty() && this.getCraftingRemainingItem() != null) {
                return new ItemStack((ItemLike)this.getCraftingRemainingItem());
            }
            if (playerEntity != null && this.getCraftingRemainingItem() != null && !playerEntity.getInventory().add(new ItemStack((ItemLike)this.getCraftingRemainingItem()))) {
                playerEntity.drop(new ItemStack((ItemLike)this.getCraftingRemainingItem()), true);
            }
        }
        return stack;
    }
}

