/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechtrees.util;

import com.mojang.logging.LogUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.slf4j.Logger;

public class RegistryHelper {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static String getItemId(Item item) {
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)item);
        return registryName.toString();
    }

    public static String getItemId(ItemStack stack) {
        return RegistryHelper.getItemId(stack.getItem());
    }

    public static String getBlockId(Block block) {
        ResourceLocation registryName = BuiltInRegistries.BLOCK.getKey((Object)block);
        return registryName.toString();
    }

    public static Item getItem(String id) {
        try {
            ResourceLocation resourceLocation = ResourceLocation.parse((String)id);
            if (BuiltInRegistries.ITEM.containsKey(resourceLocation)) {
                return (Item)BuiltInRegistries.ITEM.get(resourceLocation);
            }
        }
        catch (Exception e) {
            LOGGER.error("Invalid item ID in config: {}", (Object)id, (Object)e);
        }
        return null;
    }

    public static Block getBlock(String id) {
        try {
            ResourceLocation resourceLocation = ResourceLocation.parse((String)id);
            if (BuiltInRegistries.BLOCK.containsKey(resourceLocation)) {
                return (Block)BuiltInRegistries.BLOCK.get(resourceLocation);
            }
        }
        catch (Exception e) {
            LOGGER.error("Invalid block ID in config: {}", (Object)id, (Object)e);
        }
        return null;
    }
}

