/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechtrees.screen.custom;

import com.blocklogic.agritechtrees.block.entity.AgritechTreesPlanterBlockEntity;
import com.blocklogic.agritechtrees.compat.jei.AgritechTreesJeiPlugin;
import com.blocklogic.agritechtrees.compat.jei.PlanterRecipeCategory;
import com.blocklogic.agritechtrees.screen.custom.AgritechTreesPlanterMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class AgritechTreesPlanterScreen
extends AbstractContainerScreen<AgritechTreesPlanterMenu> {
    public static final ResourceLocation AGRITECH_PLANTER_GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"agritechtrees", (String)"textures/gui/agritech_planter_gui.png");

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    public AgritechTreesPlanterScreen(AgritechTreesPlanterMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 172;
        this.inventoryLabelY = this.imageHeight - 96;
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)AGRITECH_PLANTER_GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(AGRITECH_PLANTER_GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderProgressBar(guiGraphics, x, y);
    }

    private void renderProgressBar(GuiGraphics guiGraphics, int guiX, int guiY) {
        AgritechTreesPlanterBlockEntity blockEntity = ((AgritechTreesPlanterMenu)this.menu).blockEntity;
        if (!blockEntity.inventory.getStackInSlot(0).isEmpty() && !blockEntity.inventory.getStackInSlot(1).isEmpty()) {
            int progressX = guiX + 51;
            int progressY = guiY + 38;
            int maxProgressWidth = 21;
            int progressWidth = blockEntity.getProgressBarWidth(maxProgressWidth);
            if (progressWidth > 0) {
                guiGraphics.blit(AGRITECH_PLANTER_GUI_TEXTURE, progressX, progressY, 0, 172, progressWidth, 11);
            }
        }
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        int guiX = (this.width - this.imageWidth) / 2;
        int guiY = (this.height - this.imageHeight) / 2;
        if (x >= guiX + 51 && x <= guiX + 51 + 21 && y >= guiY + 37 && y <= guiY + 38 + 11) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            float progress = ((AgritechTreesPlanterMenu)this.menu).blockEntity.getGrowthProgress();
            tooltip.add(Component.translatable((String)"tooltip.agritech.growth_progress"));
            tooltip.add(Component.literal((String)String.format("%.1f%%", Float.valueOf(progress * 100.0f))).withStyle(ChatFormatting.GREEN));
            tooltip.add(Component.translatable((String)"tooltip.agritech.view_recipes").withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            guiGraphics.renderComponentTooltip(this.font, tooltip, x, y);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int guiX = (this.width - this.imageWidth) / 2;
            int guiY = (this.height - this.imageHeight) / 2;
            if (mouseX >= (double)(guiX + 51) && mouseX <= (double)(guiX + 51 + 21) && mouseY >= (double)(guiY + 37) && mouseY <= (double)(guiY + 38 + 11)) {
                IJeiRuntime runtime;
                if (this.minecraft != null && this.minecraft.player != null && (runtime = AgritechTreesJeiPlugin.getJeiRuntime()) != null) {
                    runtime.getRecipesGui().showTypes(List.of(PlanterRecipeCategory.PLANTER_RECIPE_RECIPE_TYPE));
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

