/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechtrees.compat.jei;

import com.blocklogic.agritechtrees.config.AgritechTreesConfig;
import com.blocklogic.agritechtrees.util.RegistryHelper;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class PlanterRecipe
implements IRecipeCategoryExtension {
    private final Ingredient saplingIngredient;
    private final Ingredient soilIngredient;
    private final List<ItemStack> outputs;

    public PlanterRecipe(Ingredient saplingIngredient, Ingredient soilIngredient, List<ItemStack> outputs) {
        this.saplingIngredient = saplingIngredient;
        this.soilIngredient = soilIngredient;
        this.outputs = outputs;
    }

    public Ingredient getSaplingIngredient() {
        return this.saplingIngredient;
    }

    public Ingredient getSeedIngredient() {
        return this.saplingIngredient;
    }

    public Ingredient getSoilIngredient() {
        return this.soilIngredient;
    }

    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public static PlanterRecipe create(String saplingId, String soilId) {
        Item saplingItem = RegistryHelper.getItem(saplingId);
        if (saplingItem == null) {
            LogUtils.getLogger().error("Failed to create tree planter recipe: Sapling item not found for ID: {}", (Object)saplingId);
            throw new IllegalArgumentException("Sapling item not found for ID: " + saplingId);
        }
        Block soilBlock = RegistryHelper.getBlock(soilId);
        if (soilBlock == null) {
            LogUtils.getLogger().error("Failed to create tree planter recipe: Soil block not found for ID: {}", (Object)soilId);
            throw new IllegalArgumentException("Soil block not found for ID: " + soilId);
        }
        Ingredient saplingIngredient = Ingredient.of((ItemLike[])new ItemLike[]{saplingItem});
        Ingredient soilIngredient = Ingredient.of((ItemLike[])new ItemLike[]{soilBlock.asItem()});
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        List<AgritechTreesConfig.DropInfo> drops = AgritechTreesConfig.getTreeDrops(saplingId);
        for (AgritechTreesConfig.DropInfo dropInfo : drops) {
            if (!(dropInfo.chance > 0.0f)) continue;
            Item dropItem = RegistryHelper.getItem(dropInfo.item);
            if (dropItem != null) {
                ItemStack outputStack = new ItemStack((ItemLike)dropItem, (dropInfo.minCount + dropInfo.maxCount) / 2);
                outputs.add(outputStack);
                continue;
            }
            LogUtils.getLogger().error("Drop item not found for ID: {} in recipe for sapling {}", (Object)dropInfo.item, (Object)saplingId);
            throw new IllegalArgumentException("Drop item not found for ID: " + dropInfo.item + " in recipe for sapling " + saplingId);
        }
        return new PlanterRecipe(saplingIngredient, soilIngredient, outputs);
    }
}

