/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechtrees.compat.jei;

import com.blocklogic.agritechtrees.block.ModBlocks;
import com.blocklogic.agritechtrees.compat.jei.PlanterRecipe;
import com.blocklogic.agritechtrees.compat.jei.PlanterRecipeCategory;
import com.blocklogic.agritechtrees.config.AgritechTreesConfig;
import com.blocklogic.agritechtrees.util.RegistryHelper;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@JeiPlugin
public class AgritechTreesJeiPlugin
implements IModPlugin {
    private static final ResourceLocation PLUGIN_ID = ResourceLocation.fromNamespaceAndPath((String)"agritechtrees", (String)"jei_plugin");
    private static IJeiRuntime jeiRuntime;

    public ResourceLocation getPluginUid() {
        return PLUGIN_ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new PlanterRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<PlanterRecipe> planterRecipes = this.generatePlanterRecipes();
        registration.addRecipes(PlanterRecipeCategory.PLANTER_RECIPE_RECIPE_TYPE, planterRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.AGRITECH_TREES_PLANTER_BLOCK.get()), new RecipeType[]{PlanterRecipeCategory.PLANTER_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.AGRITECH_TREES_HOPPING_PLANTER_BLOCK.get()), new RecipeType[]{PlanterRecipeCategory.PLANTER_RECIPE_RECIPE_TYPE});
    }

    private List<PlanterRecipe> generatePlanterRecipes() {
        ArrayList<PlanterRecipe> recipes = new ArrayList<PlanterRecipe>();
        Map<String, List<String>> saplingToSoilMap = AgritechTreesConfig.getAllSaplingToSoilMappings();
        for (Map.Entry<String, List<String>> entry : saplingToSoilMap.entrySet()) {
            String saplingId = entry.getKey();
            for (String soilId : entry.getValue()) {
                try {
                    Block soilBlock = RegistryHelper.getBlock(soilId);
                    if (soilBlock == null) {
                        LogUtils.getLogger().error("Invalid soil block in config: {} for sapling {}", (Object)soilId, (Object)saplingId);
                        continue;
                    }
                    PlanterRecipe recipe = PlanterRecipe.create(saplingId, soilId);
                    if (recipe == null || recipe.getOutputs().isEmpty()) continue;
                    recipes.add(recipe);
                }
                catch (Exception e) {
                    LogUtils.getLogger().error("Error creating recipe for sapling {} and soil {}: {}", new Object[]{saplingId, soilId, e.getMessage(), e});
                }
            }
        }
        LogUtils.getLogger().info("Generated {} tree planter recipes for JEI", (Object)recipes.size());
        return recipes;
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        AgritechTreesJeiPlugin.jeiRuntime = jeiRuntime;
    }

    public static IJeiRuntime getJeiRuntime() {
        return jeiRuntime;
    }
}

