/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritechtrees.block.custom;

import com.blocklogic.agritechtrees.block.entity.AgritechTreesPlanterBlockEntity;
import com.blocklogic.agritechtrees.block.entity.ModBlockEntities;
import com.blocklogic.agritechtrees.config.AgritechTreesConfig;
import com.blocklogic.agritechtrees.screen.custom.AgritechTreesPlanterMenu;
import com.blocklogic.agritechtrees.util.RegistryHelper;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AgritechTreesHoppingPlanterBlock
extends BaseEntityBlock {
    public static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.1, (double)15.0, (double)11.0, (double)15.0);
    public static final MapCodec<AgritechTreesHoppingPlanterBlock> CODEC = AgritechTreesHoppingPlanterBlock.simpleCodec(AgritechTreesHoppingPlanterBlock::new);

    public AgritechTreesHoppingPlanterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AgritechTreesPlanterBlockEntity(pos, state);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof AgritechTreesPlanterBlockEntity) {
            AgritechTreesPlanterBlockEntity planter = (AgritechTreesPlanterBlockEntity)blockEntity;
            planter.drops();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AgritechTreesPlanterBlockEntity) {
            ItemStack seedStack;
            AgritechTreesPlanterBlockEntity planterBlockEntity = (AgritechTreesPlanterBlockEntity)blockEntity;
            if (player.isCrouching()) {
                if (!level.isClientSide()) {
                    SimpleMenuProvider menuProvider = new SimpleMenuProvider((containerId, playerInventory, playerEntity) -> new AgritechTreesPlanterMenu(containerId, playerInventory, planterBlockEntity), (Component)Component.translatable((String)"container.agritechtrees.hopping_planter"));
                    player.openMenu((MenuProvider)menuProvider, pos);
                }
                return ItemInteractionResult.SUCCESS;
            }
            ItemStack heldItem = player.getItemInHand(hand);
            String heldItemId = RegistryHelper.getItemId(heldItem);
            if (AgritechTreesConfig.isValidSapling(heldItemId) && !AgritechTreesConfig.isValidSoil(heldItemId)) {
                if (level.isClientSide()) {
                    return ItemInteractionResult.SUCCESS;
                }
                if (planterBlockEntity.inventory.getStackInSlot(0).isEmpty()) {
                    String soilId;
                    ItemStack soilStack = planterBlockEntity.inventory.getStackInSlot(1);
                    if (!soilStack.isEmpty() && !AgritechTreesConfig.isSoilValidForSapling(soilId = RegistryHelper.getItemId(soilStack), heldItemId)) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.agritechtrees.invalid_seed_soil_combination"), true);
                        return ItemInteractionResult.SUCCESS;
                    }
                    ItemStack seedStack2 = heldItem.copyWithCount(1);
                    planterBlockEntity.inventory.setStackInSlot(0, seedStack2);
                    heldItem.shrink(1);
                    level.playSound(null, pos, SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.sendBlockUpdated(pos, state, state, 2);
                    planterBlockEntity.setChanged();
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (AgritechTreesConfig.isValidSoil(heldItemId)) {
                if (level.isClientSide()) {
                    return ItemInteractionResult.SUCCESS;
                }
                if (planterBlockEntity.inventory.getStackInSlot(1).isEmpty()) {
                    String seedId;
                    ItemStack seedStack3 = planterBlockEntity.inventory.getStackInSlot(0);
                    if (!seedStack3.isEmpty() && !AgritechTreesConfig.isSoilValidForSapling(heldItemId, seedId = RegistryHelper.getItemId(seedStack3))) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.agritechtrees.invalid_seed_soil_combination"), true);
                        return ItemInteractionResult.SUCCESS;
                    }
                    ItemStack soilStack = heldItem.copyWithCount(1);
                    planterBlockEntity.inventory.setStackInSlot(1, soilStack);
                    heldItem.shrink(1);
                    level.playSound(null, pos, SoundEvents.GRAVEL_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
                    level.sendBlockUpdated(pos, state, state, 2);
                    planterBlockEntity.setChanged();
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (heldItem.getItem() instanceof BlockItem && !(seedStack = planterBlockEntity.inventory.getStackInSlot(0)).isEmpty() && planterBlockEntity.inventory.getStackInSlot(1).isEmpty()) {
                String seedId = RegistryHelper.getItemId(seedStack);
                if (AgritechTreesConfig.isValidSoil(heldItemId) && !AgritechTreesConfig.isSoilValidForSapling(heldItemId, seedId)) {
                    if (!level.isClientSide()) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.agritechtrees.invalid_seed_soil_combination"), true);
                    }
                    return ItemInteractionResult.SUCCESS;
                }
            }
            if (!level.isClientSide()) {
                SimpleMenuProvider menuProvider = new SimpleMenuProvider((containerId, playerInventory, playerEntity) -> new AgritechTreesPlanterMenu(containerId, playerInventory, planterBlockEntity), (Component)Component.translatable((String)"container.agritechtrees.hopping_planter"));
                player.openMenu((MenuProvider)menuProvider, pos);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return type == ModBlockEntities.AGRITECH_TREES_PLANTER_BLOCK_ENTITY.get() ? (lvl, pos, blockState, be) -> AgritechTreesPlanterBlockEntity.tick(lvl, pos, blockState, (AgritechTreesPlanterBlockEntity)be) : null;
    }
}

