/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.pillar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeGenerator;
import xfacthd.framedblocks.api.shapes.ShapeProvider;

public final class PillarShapes
implements ShapeGenerator {
    public static final PillarShapes PILLAR = new PillarShapes(8);
    public static final PillarShapes POST = new PillarShapes(4);
    private final int minSize;
    private final int maxSize;

    private PillarShapes(int thickness) {
        this.minSize = 8 - thickness / 2;
        this.maxSize = 8 + thickness / 2;
    }

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeX = Block.box((double)0.0, (double)this.minSize, (double)this.minSize, (double)16.0, (double)this.maxSize, (double)this.maxSize);
        VoxelShape shapeY = Block.box((double)this.minSize, (double)0.0, (double)this.minSize, (double)this.maxSize, (double)16.0, (double)this.maxSize);
        VoxelShape shapeZ = Block.box((double)this.minSize, (double)this.minSize, (double)0.0, (double)this.maxSize, (double)this.maxSize, (double)16.0);
        for (BlockState state : states) {
            builder.put((Object)state, (Object)(switch ((Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS)) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> shapeX;
                case Direction.Axis.Y -> shapeY;
                case Direction.Axis.Z -> shapeZ;
            }));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

