/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.component.FramedMap;

public class FramedItemFrameBlockEntity
extends FramedBlockEntity {
    public static final int ROTATION_STEPS = 8;
    private static final int MAP_UPDATE_INTERVAL = 10;
    public static final String ITEM_NBT_KEY = "item";
    private final boolean glowing;
    private ItemStack heldItem = ItemStack.EMPTY;
    private int rotation = 0;
    private int mapTickOffset = 0;
    private long mapTickCount = 0L;

    public FramedItemFrameBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_ITEM_FRAME.value(), pos, state);
        this.glowing = this.getBlockType() == BlockType.FRAMED_GLOWING_ITEM_FRAME;
    }

    public void tickWithMap() {
        if (this.mapTickCount % 10L == 0L) {
            MapItemSavedData mapData;
            if (this.mapTickCount == 0L) {
                this.mapTickCount = this.mapTickOffset;
            }
            if ((mapData = MapItem.getSavedData((ItemStack)this.heldItem, (Level)this.level())) != null) {
                MapId mapId = Objects.requireNonNull((MapId)this.heldItem.get(DataComponents.MAP_ID));
                for (Player player : this.level().players()) {
                    mapData.tickCarriedBy(player, this.heldItem);
                    Packet packet = mapData.getUpdatePacket(mapId, player);
                    if (packet == null) continue;
                    ((ServerPlayer)player).connection.send(packet);
                }
            }
        }
        ++this.mapTickCount;
    }

    public ItemInteractionResult handleFrameInteraction(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.hasItem()) {
            if (!this.level().isClientSide()) {
                this.rotation = (this.rotation + 1) % 8;
                this.playSound(this.glowing ? SoundEvents.GLOW_ITEM_FRAME_ROTATE_ITEM : SoundEvents.ITEM_FRAME_ROTATE_ITEM);
                this.setChangedWithoutSignalUpdate();
                this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
            return ItemInteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (!stack.isEmpty() && !this.hasItem()) {
            if (!this.level().isClientSide()) {
                this.setItem(stack);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                player.getInventory().setChanged();
                this.playSound(this.glowing ? SoundEvents.GLOW_ITEM_FRAME_ADD_ITEM : SoundEvents.ITEM_FRAME_ADD_ITEM);
            }
            return ItemInteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void removeItem(Player player) {
        MapItemSavedData mapData;
        FramedMap map;
        if (this.heldItem.getItem() instanceof MapItem && (map = (FramedMap)this.heldItem.remove(FBContent.DC_TYPE_FRAMED_MAP)) != null && (mapData = MapItem.getSavedData((ItemStack)this.heldItem, (Level)this.level())) instanceof FramedMap.MarkerRemover) {
            FramedMap.MarkerRemover remover = (FramedMap.MarkerRemover)mapData;
            remover.framedblocks$removeMapMarker(this.worldPosition);
        }
        Utils.giveToPlayer(player, this.heldItem, true);
        this.setItem(ItemStack.EMPTY);
        this.playSound(this.glowing ? SoundEvents.GLOW_ITEM_FRAME_REMOVE_ITEM : SoundEvents.ITEM_FRAME_REMOVE_ITEM);
    }

    private void setItem(ItemStack item) {
        if (item.isEmpty()) {
            this.heldItem = ItemStack.EMPTY;
        } else {
            this.heldItem = item.copy();
            this.heldItem.setCount(1);
            if (this.heldItem.getItem() instanceof MapItem) {
                Direction dir = ((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite();
                this.heldItem.set(FBContent.DC_TYPE_FRAMED_MAP, (Object)new FramedMap(this.worldPosition, dir));
            }
        }
        this.setChangedWithoutSignalUpdate();
        if (!this.changeMapStateIfNeeded()) {
            this.level().sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean hasItem() {
        return !this.heldItem.isEmpty();
    }

    public ItemStack getItem() {
        return this.heldItem;
    }

    public ItemStack getCloneItem() {
        ItemStack stack = this.heldItem.copy();
        stack.remove(FBContent.DC_TYPE_FRAMED_MAP);
        return stack;
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isGlowingFrame() {
        return this.glowing;
    }

    private boolean changeMapStateIfNeeded() {
        boolean mapState;
        boolean mapItem = !this.heldItem.isEmpty() && this.heldItem.getItem() instanceof MapItem;
        if (mapItem != (mapState = ((Boolean)this.getBlockState().getValue((Property)PropertyHolder.MAP_FRAME)).booleanValue())) {
            this.level().setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)PropertyHolder.MAP_FRAME, (Comparable)Boolean.valueOf(mapItem)));
            this.mapTickOffset = mapItem ? this.level().random.nextInt(10) : 0;
            this.mapTickCount = this.mapTickOffset;
            return true;
        }
        return false;
    }

    private void playSound(SoundEvent sound) {
        this.level().playSound(null, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public void addAdditionalDrops(List<ItemStack> drops, boolean dropCamo) {
        super.addAdditionalDrops(drops, dropCamo);
        if (!this.heldItem.isEmpty()) {
            drops.add(this.getCloneItem());
        }
    }

    private void readFromNetwork(CompoundTag tag, HolderLookup.Provider provider) {
        this.heldItem = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(ITEM_NBT_KEY));
        this.rotation = tag.getByte("rotation");
    }

    private void writeToNetwork(CompoundTag tag, HolderLookup.Provider provider) {
        tag.put(ITEM_NBT_KEY, this.heldItem.saveOptional(provider));
        tag.putByte("rotation", (byte)this.rotation);
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.readFromNetwork(tag, lookupProvider);
        return super.readFromDataPacket(tag, lookupProvider);
    }

    @Override
    protected void writeToDataPacket(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.writeToDataPacket(tag, lookupProvider);
        this.writeToNetwork(tag, lookupProvider);
    }

    @Override
    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.readFromNetwork(tag, provider);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        this.writeToNetwork(tag, provider);
        return tag;
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.heldItem = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(ITEM_NBT_KEY));
        this.rotation = tag.getByte("rotation");
        this.mapTickOffset = tag.getInt("map_tick_offset");
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(ITEM_NBT_KEY, this.heldItem.saveOptional(provider));
        tag.putByte("rotation", (byte)this.rotation);
        tag.putInt("map_tick_offset", this.mapTickOffset);
    }
}

