/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.doubled.slopeedge;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;

public class FramedElevatedDoubleSlopeEdgeBlockEntity
extends FramedDoubleBlockEntity {
    public FramedElevatedDoubleSlopeEdgeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_ELEVATED_DOUBLE_SLOPE_EDGE.value(), pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit, Vec3 lookVec, Vec3 eyePos) {
        Direction dirTwo;
        Direction dir;
        Direction side = hit.getDirection();
        if (side == (dir = (Direction)this.getBlockState().getValue((Property)FramedProperties.FACING_HOR))) {
            return false;
        }
        SlopeType type = (SlopeType)((Object)this.getBlockState().getValue(PropertyHolder.SLOPE_TYPE));
        switch (type) {
            default: {
                throw new MatchException(null, null);
            }
            case BOTTOM: {
                Direction direction = Direction.DOWN;
                break;
            }
            case HORIZONTAL: {
                Direction direction = dir.getCounterClockWise();
                break;
            }
            case TOP: {
                Direction direction = dirTwo = Direction.UP;
            }
        }
        if (side == dirTwo) {
            return false;
        }
        Vec3 hitVec = hit.getLocation();
        if (side == dir.getOpposite()) {
            return Utils.fractionInDir(hitVec, dirTwo.getOpposite()) > 0.5;
        }
        if (side == dirTwo.getOpposite()) {
            return Utils.fractionInDir(hitVec, dir.getOpposite()) > 0.5;
        }
        double par = (Utils.fractionInDir(hitVec, dir.getOpposite()) - 0.5) * 2.0;
        double perp = (Utils.fractionInDir(hitVec, dirTwo.getOpposite()) - 0.5) * 2.0;
        if (par >= 0.0 && perp >= 0.0) {
            return perp >= 1.0 - par;
        }
        return false;
    }
}

