/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pillar;

import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.IPillarLikeBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.property.PillarConnection;

public class FramedHalfPillarBlock
extends FramedBlock
implements IPillarLikeBlock {
    private final PillarConnection pillarConnection;

    public FramedHalfPillarBlock(BlockType blockType) {
        super(blockType);
        switch (blockType) {
            case FRAMED_HALF_PILLAR: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected BlockType in FramedHalfPillarBlock: " + String.valueOf(blockType));
            }
        }
        this.pillarConnection = PillarConnection.PILLAR;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.FACING, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withTargetFacing()).withWater()).build();
    }

    @Override
    public BlockState rotate(BlockState state, Direction side, Rotation rot) {
        if (rot != Rotation.NONE) {
            return (BlockState)state.cycle((Property)BlockStateProperties.FACING);
        }
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rot.rotate(dir));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, BlockStateProperties.FACING, mirror);
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN);
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.DOWN);
    }

    @Override
    public PillarConnection getPillarConnection(BlockState state, Direction side) {
        return side == state.getValue((Property)BlockStateProperties.FACING) ? this.pillarConnection : PillarConnection.NONE;
    }
}

