/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;

public class FramedInnerCornerSlopeGeometry
extends Geometry {
    private final Direction dir;
    private final CornerType type;
    private final boolean ySlope;

    public FramedInnerCornerSlopeGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.type = (CornerType)((Object)ctx.state().getValue(PropertyHolder.CORNER_TYPE));
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        if (this.type.isHorizontal()) {
            this.createHorizontalCorner(quadMap, quad);
        } else {
            this.createVerticalCorner(quadMap, quad);
        }
    }

    private void createHorizontalCorner(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        boolean top = this.type.isTop();
        boolean right = this.type.isRight();
        if (quadDir == Direction.UP && !top || quadDir == Direction.DOWN && top) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), right ? 0.0f : 1.0f, right ? 1.0f : 0.0f)).export(quadMap.get(quadDir));
            if (this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, right ? 0.0f : 1.0f, right ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).export(quadMap.get(null));
            }
        } else if (quadDir == this.dir.getOpposite()) {
            Direction cutDir = right ? this.dir.getCounterClockWise() : this.dir.getClockWise();
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(cutDir, top ? 0.0f : 1.0f, top ? 1.0f : 0.0f)).apply(Modifiers.makeHorizontalSlope(right, 45.0f)).export(quadMap.get(null));
            if (!this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(top, right ? 1.0f : 0.0f, right ? 0.0f : 1.0f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).export(quadMap.get(null));
            }
        } else if (quadDir == this.dir.getClockWise() && !right || quadDir == this.dir.getCounterClockWise() && right) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), top ? 1.0f : 0.0f, top ? 0.0f : 1.0f)).export(quadMap.get(quadDir));
        }
    }

    private void createVerticalCorner(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        boolean top = this.type.isTop();
        if (quadDir == this.dir.getClockWise()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), top ? 1.0f : 0.0f, top ? 0.0f : 1.0f)).export(quadMap.get(quadDir));
            if (!this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, top ? 0.0f : 1.0f, top ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).export(quadMap.get(null));
            }
        } else if (quadDir == this.dir.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getClockWise(), top ? 1.0f : 0.0f, top ? 0.0f : 1.0f)).export(quadMap.get(quadDir));
            if (!this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getCounterClockWise(), top ? 0.0f : 1.0f, top ? 1.0f : 0.0f)).apply(Modifiers.makeVerticalSlope(!top, 45.0f)).export(quadMap.get(null));
            }
        } else if (this.ySlope && (!top && quadDir == Direction.UP || top && quadDir == Direction.DOWN)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 1.0f, 0.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getClockWise(), 45.0f)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.0f, 1.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getOpposite(), 45.0f)).export(quadMap.get(null));
        }
    }
}

