/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.TranslatedItemModelInfo;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;

public class FramedButtonGeometry
extends Geometry {
    static final TranslatedItemModelInfo ITEM_MODEL_INFO = TranslatedItemModelInfo.handGuiOrFixed(0.0f, 0.5f, 0.0f);
    protected final Direction dir;
    protected final AttachFace face;
    protected final Direction facing;
    protected final boolean pressed;
    private final boolean useBaseModel;

    public FramedButtonGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        this.face = (AttachFace)ctx.state().getValue((Property)BlockStateProperties.ATTACH_FACE);
        this.facing = FramedButtonGeometry.getFacing(this.dir, this.face);
        this.pressed = (Boolean)ctx.state().getValue((Property)BlockStateProperties.POWERED);
        this.useBaseModel = !ctx.state().is(FBContent.BLOCK_FRAMED_BUTTON);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (Utils.isY(this.facing)) {
            this.generateVerticalButton(quadMap, quad, quadDir);
        } else {
            this.generateHorizontalButton(quadMap, quad, quadDir);
        }
    }

    private void generateVerticalButton(QuadMap quadMap, BakedQuad quad, Direction quadDir) {
        if (quadDir.getAxis() == this.facing.getAxis()) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getAxis(), 0.625f)).apply(Modifiers.cutTopBottom(this.dir.getClockWise().getAxis(), 0.6875f)).applyIf(Modifiers.setPosition(this.pressed ? 0.0625f : 0.125f), quadDir == this.facing).export(quadMap.get(quadDir == this.facing ? null : quadDir));
        } else {
            boolean largeSide = this.dir.getAxis() == quadDir.getAxis();
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.facing == Direction.DOWN, this.pressed ? 0.0625f : 0.125f)).apply(Modifiers.cutSideLeftRight(largeSide ? 0.6875f : 0.625f)).apply(Modifiers.setPosition(largeSide ? 0.625f : 0.6875f)).export(quadMap.get(null));
        }
    }

    private void generateHorizontalButton(QuadMap quadMap, BakedQuad quad, Direction quadDir) {
        float height;
        float f = height = this.pressed ? 0.0625f : 0.125f;
        if (quadDir.getAxis() == this.facing.getAxis()) {
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.3125f, 0.375f, 0.6875f, 0.625f)).applyIf(Modifiers.setPosition(height), quadDir == this.facing).export(quadMap.get(quadDir == this.facing ? null : quadDir));
        } else if (Utils.isY(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, height)).apply(Modifiers.cutTopBottom(this.dir.getClockWise().getAxis(), 0.6875f)).apply(Modifiers.setPosition(0.625f)).export(quadMap.get(null));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, height)).apply(Modifiers.cutSideUpDown(0.625f)).apply(Modifiers.setPosition(0.6875f)).export(quadMap.get(null));
        }
    }

    @Override
    public boolean useBaseModel() {
        return this.useBaseModel;
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return ITEM_MODEL_INFO;
    }

    private static Direction getFacing(Direction dir, AttachFace face) {
        return switch (face) {
            default -> throw new MatchException(null, null);
            case AttachFace.FLOOR -> Direction.UP;
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.WALL -> dir;
        };
    }
}

